/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class AssimilatingProperty
extends Property {
    @Override
    public void onStackedOverMe(ItemStack otherStack, ItemStack stack, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (stack != otherStack && ItemStack.isSameItem((ItemStack)stack, (ItemStack)otherStack) && (stack.isDamaged() || !InfusedPropertiesHelper.getInfusedProperties(otherStack).isEmpty() && InfusedPropertiesHelper.getRemainingInfusionSlots(stack) > 0 || EnchantmentHelper.hasAnyEnchantments((ItemStack)otherStack))) {
            AssimilatingProperty.repairItem(stack, stack.getMaxDamage() - otherStack.getDamageValue());
            this.combineEnchantments(stack, otherStack);
            stackedOnSlot.set(this.combineInfusions(player.level(), stack, otherStack));
            otherStack.shrink(1);
            isCancelled.set(true);
        }
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (stack.isDamageableItem() && user instanceof Player) {
            Player player = (Player)user;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack otherStack = player.getInventory().getItem(i);
                if (stack == otherStack || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)otherStack) || !AssimilatingProperty.shouldRepair(stack) && stack.getDamageValue() < stack.getMaxDamage() - otherStack.getDamageValue()) continue;
                AssimilatingProperty.repairItem(stack, stack.getMaxDamage() - otherStack.getDamageValue());
                if (stack == user.getItemBySlot(slot)) {
                    this.combineEnchantments(stack, otherStack);
                    user.setItemSlot(slot, this.combineInfusions(user.level(), stack, otherStack));
                }
                player.getInventory().removeItem(i, 1);
                return;
            }
        }
    }

    public static boolean shouldRepair(ItemStack stack) {
        return AssimilatingProperty.canRepair(stack, 5);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 6485863;
    }

    private ItemStack combineInfusions(Level level, ItemStack to, ItemStack from) {
        List<Holder<Property>> toCombine = InfusedPropertiesHelper.getInfusedProperties(from);
        InfusedPropertiesHelper.addProperties(to, toCombine);
        for (Holder<Property> property : toCombine) {
            Object object = property.value();
            if (!(object instanceof IDataHolder)) continue;
            IDataHolder dataHolder = (IDataHolder)object;
            dataHolder.combineDataAndSet(to, from);
        }
        to = ForgeRecipeGrid.resolveInteractions(to, level);
        return to;
    }

    private void combineEnchantments(ItemStack to, ItemStack from) {
        ItemEnchantments.Mutable itemenchantments$mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)to));
        ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)from);
        boolean flag2 = false;
        boolean flag3 = false;
        for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
            int j2;
            Holder holder = (Holder)entry.getKey();
            int i2 = itemenchantments$mutable.getLevel(holder);
            j2 = i2 == (j2 = entry.getIntValue()) ? j2 + 1 : Math.max(j2, i2);
            Enchantment enchantment = (Enchantment)holder.value();
            boolean supportsEnchantment = to.supportsEnchantment(holder);
            for (Holder holder1 : itemenchantments$mutable.keySet()) {
                if (holder1.equals((Object)holder) || Enchantment.areCompatible((Holder)holder, (Holder)holder1)) continue;
                supportsEnchantment = false;
            }
            if (!supportsEnchantment) continue;
            if (j2 > enchantment.getMaxLevel()) {
                j2 = enchantment.getMaxLevel();
            }
            itemenchantments$mutable.set(holder, j2);
        }
        EnchantmentHelper.setEnchantments((ItemStack)to, (ItemEnchantments)itemenchantments$mutable.toImmutable());
    }
}

