/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Optional;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class BowProperty
extends Property {
    @Override
    public void onStopUsingItem(ItemStack stack, LivingEntity user, LivingEntityUseItemEvent.Stop event) {
        if (event.getDuration() > 5) {
            Items.BOW.asItem().releaseUsing(new ItemStack((ItemLike)Items.BOW), user.level(), user, event.getDuration());
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled() && this.canUse(event.getLevel(), event.getEntity(), event.getHand())) {
            event.getEntity().startUsingItem(event.getHand());
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.isCanceled() && this.canUse(event.getLevel(), event.getEntity(), event.getHand())) {
            event.getEntity().startUsingItem(event.getHand());
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }

    public boolean canUse(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack;
        boolean flag = !player.getProjectile(itemstack = new ItemStack((ItemLike)Items.BOW)).isEmpty();
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)flag);
        if (ret != null) {
            return ret.getResult().consumesAction();
        }
        return player.hasInfiniteMaterials() || flag;
    }

    @Override
    public Optional<UseAnim> modifyUseAnimation(ItemStack stack, UseAnim original, Optional<UseAnim> current) {
        return current.isEmpty() ? Optional.of(UseAnim.BOW) : current;
    }

    @Override
    public int modifyUseDuration(ItemStack stack, int original, int result) {
        return 72000;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 8790440;
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

