/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Optional;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

public class BrushProperty
extends Property {
    @Override
    public int modifyUseDuration(ItemStack stack, int original, int result) {
        return Math.max(result, 200);
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        if (!event.isCanceled() && event.getPlayer() != null) {
            event.getPlayer().startUsingItem(event.getHand());
            event.setCancellationResult(ItemInteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        return InfusionPropertyDispenseBehavior.executeItemBehavior(blockSource, stack, Items.BRUSH);
    }

    @Override
    public void onItemUseTick(LivingEntity user, ItemStack stack, LivingEntityUseItemEvent.Tick event) {
        Items.BRUSH.onUseTick(user.level(), user, stack, event.getDuration());
    }

    @Override
    public boolean modifyAcceptAbility(ItemStack stack, ItemAbility itemAbility, boolean original, boolean result) {
        return result || ItemAbilities.DEFAULT_BRUSH_ACTIONS.contains(itemAbility);
    }

    @Override
    public Optional<UseAnim> modifyUseAnimation(ItemStack stack, UseAnim original, Optional<UseAnim> current) {
        return Optional.of(UseAnim.BRUSH);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 15647642;
    }
}

