/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Optional;
import javax.annotation.Nullable;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class BucketingProperty
extends Property
implements IDataHolder<Fluid> {
    @Override
    public int getColor(ItemStack stack) {
        return 2511981;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        Component name = super.getDisplayText(stack);
        Fluid storedFluid = (Fluid)this.getData(stack);
        if (!storedFluid.equals(this.getDefaultData())) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, storedFluid.defaultFluidState().createLegacyBlock().getBlock().getName()}).withColor(this.getColor(stack));
        }
        return name;
    }

    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        return dataType == DataComponents.MAX_STACK_SIZE ? Integer.valueOf(1) : data;
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled() && this.handleInteraction(event.getLevel(), event.getItemStack(), event.getEntity())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        if (!event.isCanceled() && this.handleInteraction(event.getLevel(), event.getItemStack(), event.getPlayer())) {
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        if (this.handleInteraction((Level)blockSource.level(), stack, blockSource.pos().relative(direction), direction, null)) {
            InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
            return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
        }
        return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
    }

    private boolean handleInteraction(Level level, ItemStack stack, Player user) {
        Fluid storedFluid = (Fluid)this.getData(stack);
        BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)level, (Player)user, (ClipContext.Fluid)(storedFluid.equals(Fluids.EMPTY) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        BlockPos hitPos = hitResult.getBlockPos();
        Direction hitDirection = hitResult.getDirection();
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            return this.handleInteraction(level, stack, hitPos, hitDirection, user);
        }
        return false;
    }

    private boolean handleInteraction(Level level, ItemStack stack, BlockPos pos, Direction direction, @Nullable Player user) {
        Fluid storedFluid = (Fluid)this.getData(stack);
        BlockState state = level.getBlockState(pos);
        if (storedFluid.equals(this.getDefaultData())) {
            BucketPickup bucketPickup;
            Block block = state.getBlock();
            if (block instanceof BucketPickup && (block = (bucketPickup = (BucketPickup)block).pickupBlock(user, (LevelAccessor)level, pos, state).getItem()) instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)block;
                if (user != null) {
                    bucketPickup.getPickupSound(state).ifPresent(sound -> user.playSound(sound, 1.0f, 1.0f));
                    level.gameEvent((Entity)user, (Holder)GameEvent.FLUID_PICKUP, pos);
                } else {
                    bucketPickup.getPickupSound(state).ifPresent(sound -> level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 0.5f));
                    level.gameEvent((Holder)GameEvent.FLUID_PICKUP, pos, GameEvent.Context.of((BlockState)state));
                }
                if (!InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.NULLIFIER)) {
                    this.setData(stack, bucketItem.content);
                }
                return true;
            }
        } else if (this.placeLiquid(level, pos, storedFluid, user, direction)) {
            this.setData(stack, this.getDefaultData());
            return true;
        }
        return false;
    }

    public boolean isEmpty(ItemStack stack) {
        return ((Fluid)this.getData(stack)).equals(this.getDefaultData());
    }

    @Override
    public void onEntityItemDestroyed(ItemStack stack, Entity itemEntity, DamageSource damageSource) {
        block5: {
            block4: {
                if (stack.has(DataComponents.INTANGIBLE_PROJECTILE)) break block4;
                if (!(itemEntity instanceof AbstractArrow)) break block5;
                AbstractArrow arrow = (AbstractArrow)itemEntity;
                if (arrow.pickup != AbstractArrow.Pickup.DISALLOWED) break block5;
            }
            return;
        }
        if (this.placeLiquid(itemEntity.level(), itemEntity.blockPosition(), (Fluid)this.getData(stack), null, null)) {
            this.setData(stack, this.getDefaultData());
        }
    }

    public boolean placeLiquid(Level level, BlockPos hitPos, ItemStack sourceStack, @Nullable Player user, @Nullable Direction hitDirection) {
        if (this.placeLiquid(level, hitPos, (Fluid)this.getData(sourceStack), user, hitDirection)) {
            this.setData(sourceStack, this.getDefaultData());
            return true;
        }
        return false;
    }

    protected boolean placeLiquid(Level level, BlockPos hitPos, Fluid storedFluid, @Nullable Player user, @Nullable Direction hitDirection) {
        LiquidBlockContainer liquidBlockContainer;
        if (storedFluid.equals(this.getDefaultData())) {
            return false;
        }
        BlockState hitState = level.getBlockState(hitPos);
        Block block = hitState.getBlock();
        if (block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(user, (BlockGetter)level, hitPos, hitState, storedFluid)) {
            liquidBlockContainer.placeLiquid((LevelAccessor)level, hitPos, hitState, storedFluid.defaultFluidState());
            this.playEmptySound(user, (LevelAccessor)level, hitPos, storedFluid);
            return true;
        }
        if (storedFluid.getFluidType().isVaporizedOnPlacement(level, hitPos, FluidStack.EMPTY)) {
            storedFluid.getFluidType().onVaporize(user, level, hitPos, FluidStack.EMPTY);
            return true;
        }
        if (level.dimensionType().ultraWarm() && storedFluid.is(FluidTags.WATER)) {
            int l = hitPos.getX();
            int i = hitPos.getY();
            int j = hitPos.getZ();
            level.playSound(user, hitPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (hitState.canBeReplaced(storedFluid)) {
            if (!level.isClientSide() && !hitState.liquid()) {
                level.destroyBlock(hitPos, true);
            }
        } else if (hitDirection != null) {
            hitPos = hitPos.relative(hitDirection);
            hitState = level.getBlockState(hitPos);
        }
        if ((hitState.isAir() || hitState.canBeReplaced(storedFluid)) && level.setBlock(hitPos, storedFluid.defaultFluidState().createLegacyBlock(), 11) || hitState.getFluidState().isSource()) {
            this.playEmptySound(user, (LevelAccessor)level, hitPos, storedFluid);
            return true;
        }
        return false;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos, Fluid fluid) {
        SoundEvent soundevent = fluid.getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = fluid.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        level.playSound(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, pos);
    }

    @Override
    public Fluid readData(CompoundTag tag) {
        Optional fluid;
        if (tag.contains("fluid", 8) && (fluid = CommonUtils.registryAccessStatic().lookupOrThrow(Registries.FLUID).get(ResourceKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)tag.getString("fluid"))))).isPresent()) {
            return (Fluid)((Holder.Reference)fluid.get()).value();
        }
        return this.getDefaultData();
    }

    @Override
    public CompoundTag writeData(final Fluid data) {
        return new CompoundTag(this){
            {
                if (!data.equals(Fluids.EMPTY)) {
                    this.putString("fluid", BuiltInRegistries.FLUID.getKey((Object)data).toString());
                }
            }
        };
    }

    @Override
    public Fluid getDefaultData() {
        return Fluids.EMPTY;
    }
}

