/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

public class CapturingProperty
extends Property
implements IDataHolder<EntityData<?>> {
    private static final EntityData<?> DEFAULT = new EntityData(null, new CompoundTag(), (Component)Component.empty());

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        if (rayTraceResult.getType() == HitResult.Type.ENTITY && rayTraceResult instanceof EntityHitResult && this.captureMob((entityHitResult = (EntityHitResult)rayTraceResult).getEntity(), stack)) {
            projectile.spawnAtLocation(stack);
            projectile.discard();
            event.setCanceled(true);
        } else if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.LOYAL)) {
            this.releaseMob(projectile.level(), stack, projectile.position(), projectile.getDeltaMovement().scale(-1.0));
        }
    }

    @Override
    public void onEntityItemDestroyed(ItemStack stack, Entity itemEntity, DamageSource damageSource) {
        block3: {
            block2: {
                if (stack.has(DataComponents.INTANGIBLE_PROJECTILE)) break block2;
                if (!(itemEntity instanceof AbstractArrow)) break block3;
                AbstractArrow arrow = (AbstractArrow)itemEntity;
                if (arrow.pickup != AbstractArrow.Pickup.DISALLOWED) break block3;
            }
            return;
        }
        this.releaseMob(itemEntity.level(), stack, itemEntity.position(), itemEntity.getDeltaMovement().scale(-1.0));
    }

    @Override
    public void onActivation(Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        Vec3 lookVec = new Vec3(0.0, 1.0, 0.0);
        if (source == null) {
            source = target;
        } else {
            lookVec = source.getLookAngle();
        }
        this.releaseMob(source.level(), stack, source.position().add(lookVec), lookVec);
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        BlockPos blockpos;
        if (this.releaseMob((Level)blockSource.level(), stack, blockSource.pos().relative(direction).getCenter(), new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()))) {
            InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
            return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
        }
        ServerLevel serverlevel = blockSource.level();
        List list = serverlevel.getEntitiesOfClass(Entity.class, new AABB(blockpos = blockSource.pos().relative((Direction)blockSource.state().getValue((net.minecraft.world.level.block.state.properties.Property)DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
        if (!list.isEmpty() && this.captureMob((Entity)list.getFirst(), stack)) {
            InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
            return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
        }
        return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Vec3 lookVec = event.getEntity().getLookAngle();
        if (!event.isCanceled()) {
            if (((EntityData)this.getData(event.getItemStack())).equals(this.getDefaultData())) {
                if (this.releaseMob(event.getLevel(), event.getItemStack(), event.getEntity().position().add(lookVec), lookVec)) {
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            } else {
                EntityHitResult hitResult = CapturingProperty.getPlayerPOVHitResult(event.getLevel(), event.getEntity());
                if (hitResult != null) {
                    if (this.captureMob(hitResult.getEntity(), event.getItemStack())) {
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                    } else {
                        event.getEntity().displayClientMessage((Component)Component.translatable((String)"property.alchemancy.capturing.cannot_store", (Object[])new Object[]{hitResult.getEntity().getDisplayName()}).withStyle(ChatFormatting.RED), true);
                    }
                }
            }
        }
    }

    public static EntityHitResult getPlayerPOVHitResult(Level level, Player player) {
        Vec3 vec3 = player.getEyePosition();
        Vec3 vec31 = vec3.add(player.calculateViewVector(player.getXRot(), player.getYRot()).scale(player.entityInteractionRange()));
        return ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)player.position(), (Vec3)vec31, (AABB)player.getBoundingBox(), entity -> true);
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        Vec3i faceNormal = event.getFace().getNormal();
        if (this.releaseMob(event.getLevel(), event.getItemStack(), event.getPos().relative(event.getFace()).getCenter(), new Vec3((double)faceNormal.getX(), (double)faceNormal.getY(), (double)faceNormal.getZ()))) {
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.captureMob(event.getTarget(), event.getItemStack())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        } else {
            event.getEntity().displayClientMessage((Component)Component.translatable((String)"property.alchemancy.capturing.cannot_store", (Object[])new Object[]{event.getTarget().getDisplayName()}).withStyle(ChatFormatting.RED), true);
        }
    }

    public boolean releaseMob(Level level, ItemStack stack, Vec3 position, @Nullable Vec3 direction) {
        EntityData data = (EntityData)this.getData(stack);
        if (level.isClientSide() || data.equals(this.getDefaultData())) {
            return false;
        }
        Object entity = this.getEntityFromData(data, level);
        if (entity == null) {
            return false;
        }
        entity.setPos(position);
        if (direction != null) {
            CapturingProperty.setMobDirection(entity, direction);
        }
        if (((ServerLevel)level).getEntity(entity.getUUID()) != null) {
            entity.setUUID(Mth.createInsecureUUID((RandomSource)entity.getRandom()));
        }
        level.addFreshEntity(entity);
        this.setData(stack, this.getDefaultData());
        return true;
    }

    public boolean captureMob(@Nonnull Entity target, ItemStack stack) {
        if (!((EntityData)this.getData(stack)).equals(this.getDefaultData()) || target.getType().is(AlchemancyTags.EntityTypes.CANNOT_CAPTURE)) {
            return false;
        }
        if (!InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.NULLIFIER)) {
            this.setData(stack, this.getDataFromEntity(target));
        }
        target.discard();
        return true;
    }

    public static void setMobDirection(@Nonnull Entity target, Vec3 direction) {
        target.setDeltaMovement(direction.normalize().scale(target.getDeltaMovement().length()));
        target.hurtMarked = true;
        target.hasImpulse = true;
    }

    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        return dataType == DataComponents.MAX_STACK_SIZE ? Integer.valueOf(1) : data;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 2452267;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        Component name = super.getDisplayText(stack);
        EntityData entityData = (EntityData)this.getData(stack);
        if (!entityData.equals(this.getDefaultData())) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, entityData.name}).withColor(this.getColor(stack));
        }
        return name;
    }

    public EntityData<?> getDataFromEntity(final Entity entity) {
        return new EntityData(entity.getType(), new CompoundTag(this){
            {
                entity.save((CompoundTag)this);
            }
        }, entity.getName());
    }

    @Nullable
    public <T extends Entity> T getEntityFromData(EntityData<T> data, Level level) {
        Entity entity;
        if (data.entityType != null && (entity = data.entityType.create(level)) != null) {
            entity.load(data.data);
            return (T)entity;
        }
        return null;
    }

    @Override
    public EntityData<?> readData(CompoundTag tag) {
        Optional entityType;
        if (tag.contains("entity_id", 8) && (entityType = CommonUtils.registryAccessStatic().lookupOrThrow(Registries.ENTITY_TYPE).get(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("entity_id"))))).isPresent()) {
            return new EntityData((EntityType)((Holder.Reference)entityType.get()).value(), tag.getCompound("data"), (Component)(tag.contains("name", 8) ? Component.Serializer.fromJson((String)tag.getString("name"), (HolderLookup.Provider)CommonUtils.registryAccessStatic()) : Component.empty()));
        }
        return this.getDefaultData();
    }

    @Override
    public CompoundTag writeData(final EntityData<?> data) {
        return new CompoundTag(this){
            {
                if (data.entityType != null) {
                    this.putString("entity_id", BuiltInRegistries.ENTITY_TYPE.getKey(data.entityType).toString());
                    if (!data.data.isEmpty()) {
                        this.put("data", (Tag)data.data);
                    }
                    this.putString("name", Component.Serializer.toJson((Component)data.name, (HolderLookup.Provider)CommonUtils.registryAccessStatic()));
                }
            }
        };
    }

    @Override
    public EntityData<?> getDefaultData() {
        return DEFAULT;
    }

    public record EntityData<T extends Entity>(@Nullable EntityType<T> entityType, CompoundTag data, Component name) {
    }
}

