/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.network.S2CPlayFireworksPayload;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.util.ColorUtils;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class CracklingProperty
extends Property
implements IDataHolder<Fireworks> {
    private static final float timePerStar = 2.0f;
    private static final Fireworks DEFAULT = new Fireworks(0, List.of(new FireworkExplosion(FireworkExplosion.Shape.SMALL_BALL, IntList.of((int)0xFFFFFF), IntList.of(), false, false)));

    @Override
    public void onCriticalAttack(@Nullable Player user, ItemStack weapon, Entity target) {
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Fireworks fireworks = (Fireworks)this.getData(weapon);
            Vec3 targetPos = target.getEyePosition();
            float damage = 2.0f;
            if (fireworks != null) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)target, (CustomPacketPayload)new S2CPlayFireworksPayload(fireworks, targetPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                List list = fireworks.explosions();
                if (!list.isEmpty()) {
                    damage = 5.0f + (float)(list.size() * 2);
                }
            } else {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)target, (CustomPacketPayload)new S2CPlayFireworksPayload(DEFAULT, targetPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            for (LivingEntity livingentity : level2.getEntitiesOfClass(LivingEntity.class, CommonUtils.boundingBoxAroundPoint(targetPos, 5.0f))) {
                if (target == user || targetPos.distanceToSqr(livingentity.position()) > 25.0) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    Vec3 vec31 = new Vec3(livingentity.getX(), livingentity.getY(0.5 * (double)i), livingentity.getZ());
                    BlockHitResult hitresult = level2.clip(new ClipContext(targetPos, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, target));
                    if (hitresult.getType() != HitResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float localDamage = damage * (float)Math.sqrt((5.0 - targetPos.distanceTo(livingentity.position())) / 5.0);
                livingentity.hurt(level2.damageSources().source(DamageTypes.FIREWORKS, (Entity)user, (Entity)user), localDamage);
            }
            this.damageOrConsumeItem(target.level(), (Entity)user, weapon, EquipmentSlot.MAINHAND, (int)(damage / 2.0f));
        }
    }

    @Override
    public boolean onInfusedByDormantProperty(ItemStack stack, ItemStack propertySource, ForgeRecipeGrid grid, List<Holder<Property>> propertiesToAdd, boolean consumeItem) {
        Fireworks stackFireworks = (Fireworks)propertySource.get(DataComponents.FIREWORKS);
        if (stackFireworks == null && propertySource.has(DataComponents.FIREWORK_EXPLOSION)) {
            stackFireworks = new Fireworks(0, List.of((FireworkExplosion)propertySource.get(DataComponents.FIREWORK_EXPLOSION)));
        }
        if (stackFireworks != null && stackFireworks.explosions().isEmpty()) {
            return false;
        }
        if (InfusedPropertiesHelper.hasInfusedProperty(stack, this.asHolder())) {
            List currentExplosions;
            List stackExplosions = stackFireworks == null ? List.of() : stackFireworks.explosions();
            Fireworks currentFireworks = (Fireworks)this.getData(stack);
            List list = currentExplosions = currentFireworks == null ? List.of() : currentFireworks.explosions();
            if (stackExplosions == currentExplosions) {
                return false;
            }
        }
        if (consumeItem) {
            this.setData(stack, stackFireworks);
        }
        return true;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        Fireworks fireworks = (Fireworks)this.getData(stack);
        if (fireworks == null || fireworks.explosions().isEmpty()) {
            return super.getDisplayText(stack);
        }
        List explosions = fireworks.explosions();
        int currentIndex = (int)Math.abs((double)System.currentTimeMillis() / 2000.0 % (double)explosions.size());
        FireworkExplosion explosion = (FireworkExplosion)explosions.get(currentIndex);
        MutableComponent colors = Component.empty();
        for (int i = 0; i < explosion.colors().size(); ++i) {
            colors = colors.append((Component)Component.translatable((String)"property.detail.star").withColor(explosion.fadeColors().isEmpty() ? explosion.colors().getInt(i) : ColorUtils.interpolateColorsOverTime(2.0f, explosion.colors().getInt(i), explosion.fadeColors().getInt(Math.min(i, explosion.fadeColors().size() - 1)))));
        }
        return Component.translatable((String)"property.crackling_detail", (Object[])new Object[]{super.getDisplayText(stack), colors, explosion.shape().getName().withStyle(ChatFormatting.WHITE)}).withColor(this.getColor(stack));
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(0.5f, 14035498, 0xFF8888);
    }

    @Override
    public Fireworks readData(CompoundTag tag) {
        return tag.contains("fireworks") ? (Fireworks)Fireworks.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("fireworks")).getOrThrow() : null;
    }

    @Override
    public CompoundTag writeData(final Fireworks data) {
        return new CompoundTag(this){
            {
                if (data != null) {
                    this.put("fireworks", (Tag)Fireworks.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)data).getOrThrow());
                }
            }
        };
    }

    @Override
    public Fireworks getDefaultData() {
        return DEFAULT;
    }
}

