/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.item.components.PropertyModifierComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class DenseProperty
extends Property {
    @Override
    public void onIncomingAttack(Entity user, ItemStack weapon, LivingEntity target, LivingIncomingDamageEvent event) {
        if (DenseProperty.canSmashAttack(user)) {
            event.setAmount(event.getAmount() + this.getAttackDamageBonus((Entity)target, event.getSource()) * PropertyModifierComponent.getOrElse(weapon, this.asHolder(), AlchemancyProperties.Modifiers.ATTACK_DAMAGE, Float.valueOf(0.65f)).floatValue());
        }
    }

    public static boolean canSmashAttack(Entity entity) {
        LivingEntity living;
        return entity.fallDistance > 1.5f && (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).isFallFlying());
    }

    public float getAttackDamageBonus(Entity target, DamageSource damageSource) {
        Entity entity = damageSource.getDirectEntity();
        if (entity instanceof LivingEntity) {
            float f;
            LivingEntity livingentity = (LivingEntity)entity;
            if (!DenseProperty.canSmashAttack((Entity)livingentity)) {
                return 0.0f;
            }
            float f1 = livingentity.fallDistance;
            float f2 = f1 <= 3.0f ? 4.0f * f1 : (f1 <= 8.0f ? 12.0f + 2.0f * (f1 - 3.0f) : 22.0f + f1 - 8.0f);
            Level level = livingentity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                f = f2 + EnchantmentHelper.modifyFallBasedDamage((ServerLevel)serverlevel, (ItemStack)livingentity.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)0.0f) * f1;
            } else {
                f = f2;
            }
            return f;
        }
        return 0.0f;
    }

    @Override
    public void onFall(LivingEntity entity, ItemStack stack, EquipmentSlot slot, LivingFallEvent event) {
        if ((slot == EquipmentSlot.FEET || slot == EquipmentSlot.BODY) && MaceItem.canSmashAttack((LivingEntity)entity)) {
            entity.playSound(entity.fallDistance > 5.0f ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND, 1.0f, 1.0f);
            if (!entity.level().isClientSide()) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity;
                    serverplayer.setSpawnExtraParticlesOnFall(true);
                }
                float radius = PropertyModifierComponent.getOrElse(stack, this.asHolder(), AlchemancyProperties.Modifiers.EFFECT_VALUE, Float.valueOf(1.5f)).floatValue();
                for (LivingEntity target : entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate((double)radius))) {
                    DamageSource damageSource;
                    if (target == entity || !(target.distanceTo((Entity)entity) <= radius)) continue;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        damageSource = entity.damageSources().playerAttack(player);
                    } else {
                        damageSource = entity.damageSources().mobAttack(entity);
                    }
                    DamageSource damageSource2 = damageSource;
                    target.hurt(damageSource2, this.getAttackDamageBonus((Entity)target, damageSource2) * PropertyModifierComponent.getOrElse(stack, this.asHolder(), AlchemancyProperties.Modifiers.EFFECT_VALUE, Float.valueOf(0.65f)).floatValue());
                }
                if (entity.fallDistance >= 6.0f) {
                    DenseProperty.activateByEntity((Entity)entity, (Entity)entity, stack);
                }
                this.damageItem((Entity)entity, stack, slot, (int)(entity.fallDistance * 0.5f));
            }
        }
    }

    @Override
    public TriState isItemInTag(ItemStack stack, TagKey<Item> tagKey) {
        return tagKey == ItemTags.MACE_ENCHANTABLE ? TriState.TRUE : super.isItemInTag(stack, tagKey);
    }

    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity entity) {
        if (entity.isInFluidType()) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)-0.03f, 0.0));
            entity.hasImpulse = true;
        }
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile entity) {
        if (entity.isInFluidType()) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)-0.03f, 0.0));
            entity.hasImpulse = true;
        }
    }

    @Override
    public void onEquippedTick(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        if (entity.isInFluidType()) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)-0.08f, 0.0));
            entity.hasImpulse = true;
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 10068398;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        return super.getDisplayText(stack).copy().withStyle(ChatFormatting.BOLD);
    }
}

