/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class DisguisedProperty
extends Property
implements IDataHolder<ItemStack> {
    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (event.getHand() == InteractionHand.MAIN_HAND) {
            ItemStack disguise = event.getEntity().getOffhandItem();
            if (((ItemStack)this.getData(stack)).isEmpty() && !disguise.isEmpty()) {
                this.setData(stack, disguise);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public void onStackedOverMe(ItemStack disguise, ItemStack stack, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (clickAction == ClickAction.SECONDARY && ((ItemStack)this.getData(stack)).isEmpty() && !disguise.isEmpty()) {
            this.setData(stack, disguise);
            isCancelled.set(true);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 9587497;
    }

    @Override
    public ItemStack readData(CompoundTag tag) {
        return tag.isEmpty() ? this.getDefaultData() : ItemStack.parse((HolderLookup.Provider)CommonUtils.registryAccessStatic(), (Tag)tag.getCompound("item")).orElse(this.getDefaultData());
    }

    @Override
    public CompoundTag writeData(final ItemStack data) {
        return new CompoundTag(this){
            {
                if (!data.isEmpty()) {
                    this.put("item", data.save((HolderLookup.Provider)CommonUtils.registryAccessStatic()));
                }
            }
        };
    }

    @Override
    public ItemStack getDefaultData() {
        return ItemStack.EMPTY;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        Component name = super.getDisplayText(stack);
        ItemStack disguise = (ItemStack)this.getData(stack);
        if (!disguise.isEmpty()) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, disguise.getHoverName()}).withColor(this.getColor(stack));
        }
        return name;
    }
}

