/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.cibernet.alchemancy.entity.InfusedItemProjectile;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.network.C2SDispenseFromBootsPayload;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class DispensingProperty
extends Property {
    private static final GameProfile FAKE_GAME_PROFILE = new GameProfile(UUID.randomUUID(), "Michael");

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (projectile.level().isClientSide()) {
            return;
        }
        Level level = projectile.level();
        Vec3 direction = projectile.position().subtract(rayTraceResult.getLocation());
        double d0 = direction.horizontalDistance();
        float xRot = (float)(Mth.atan2((double)direction.y, (double)d0) * 180.0 / Math.PI);
        float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 180.0 / Math.PI);
        GameProfile profile = FAKE_GAME_PROFILE;
        Player michael = CommonUtils.createFakePlayer(level, profile);
        michael.moveTo(projectile.position().subtract(0.0, (double)projectile.getEyeHeight(), 0.0), yRot, xRot);
        michael.setYHeadRot(yRot);
        stack = InfusedPropertiesHelper.removeProperty(stack.copy(), AlchemancyProperties.THROWABLE);
        InfusedPropertiesHelper.removeProperty(stack, AlchemancyProperties.DISPENSING);
        michael.setItemInHand(InteractionHand.MAIN_HAND, stack);
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult clip = (BlockHitResult)rayTraceResult;
            UseOnContext context = new UseOnContext(level, michael, InteractionHand.MAIN_HAND, stack, new BlockHitResult(clip.getLocation(), clip.getDirection(), clip.getBlockPos(), clip.isInside()));
            InteractionResult result = DispensingProperty.useItemOnBlock(michael, InteractionHand.MAIN_HAND, context);
            if (!result.consumesAction()) {
                result = DispensingProperty.useItem(michael, InteractionHand.MAIN_HAND);
                stack = michael.getItemInHand(InteractionHand.MAIN_HAND);
            } else {
                stack = context.getItemInHand();
            }
        } else {
            DispensingProperty.useItem(michael, InteractionHand.MAIN_HAND);
            stack = michael.getItemInHand(InteractionHand.MAIN_HAND);
        }
        if (stack.isEmpty()) {
            projectile.discard();
        } else if (projectile instanceof InfusedItemProjectile) {
            InfusedItemProjectile infusedItemProjectile = (InfusedItemProjectile)projectile;
            infusedItemProjectile.setItem(stack);
        }
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        BlockHitResult check;
        if (slot != EquipmentSlot.FEET && slot != EquipmentSlot.BODY || user.tickCount % 5 != 0 || user.getKnownMovement().lengthSqr() <= 0.007) {
            return;
        }
        Level level = user.level();
        ItemStack stored = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(stack);
        if (stored.isEmpty() || user instanceof Player && !level.isClientSide()) {
            return;
        }
        if (!user.onGround() && (check = level.clip(new ClipContext(user.position(), new Vec3(user.getX(), Math.ceil(user.getY() * 4.0) / 4.0 - 2.0, user.getZ()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user))).getType() == HitResult.Type.MISS) {
            return;
        }
        DispensingProperty.placeFromBoots(user, stack);
        if (user instanceof Player) {
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SDispenseFromBootsPayload(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void placeFromBoots(LivingEntity user, ItemStack stack) {
        ItemStack resultStack;
        InteractionResult result;
        GameProfile gameProfile;
        Level level = user.level();
        ItemStack stored = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(stack);
        if (user instanceof Player) {
            Player player = (Player)user;
            gameProfile = player.getGameProfile();
        } else {
            gameProfile = FAKE_GAME_PROFILE;
        }
        GameProfile profile = gameProfile;
        Player michael = CommonUtils.createFakePlayer(level, profile);
        michael.moveTo(user.position().subtract(0.0, (double)user.getEyeHeight(), 0.0), user.getYRot(), 90.0f);
        michael.setYHeadRot(user.getYHeadRot());
        michael.setPose(user.getPose());
        michael.setItemInHand(InteractionHand.MAIN_HAND, stored);
        BlockHitResult clip = level.clip(new ClipContext(user.position(), new Vec3(user.getX(), Math.ceil(user.getY() * 4.0) / 4.0 - 1.0, user.getZ()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user));
        UseOnContext context = new UseOnContext(level, michael, InteractionHand.MAIN_HAND, stored, new BlockHitResult(clip.getLocation(), Direction.UP, clip.getBlockPos(), clip.isInside()));
        Item item = stored.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            double yFloor = Math.floor(user.getY());
            double yDecimal = user.getY() - yFloor;
            BlockState placeState = blockItem.getBlock().getStateForPlacement(new BlockPlaceContext(context));
            if (placeState != null) {
                double topY = (double)context.getClickedPos().getY() + placeState.getCollisionShape((BlockGetter)level, context.getClickedPos()).max(Direction.Axis.Y);
                if (user.getY() < topY) {
                    user.setPos(user.getX(), topY, user.getZ());
                }
            }
        }
        if (!(result = DispensingProperty.useItemOnBlock(michael, InteractionHand.MAIN_HAND, context)).consumesAction()) {
            result = DispensingProperty.useItem(michael, InteractionHand.MAIN_HAND);
            resultStack = michael.getItemInHand(InteractionHand.MAIN_HAND);
        } else {
            resultStack = context.getItemInHand();
        }
        ((HollowProperty)AlchemancyProperties.HOLLOW.get()).setData(stack, resultStack);
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        ItemStack stored = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(event.getItemStack());
        if (stored.isEmpty()) {
            return;
        }
        Player michael = CommonUtils.createFakePlayer(level, player.getGameProfile());
        michael.moveTo(player.position(), player.getYRot(), player.getXRot());
        michael.setYHeadRot(player.getYHeadRot());
        michael.setPose(player.getPose());
        michael.setItemInHand(event.getHand(), stored.copy());
        InteractionResult result = DispensingProperty.useItem(michael, event.getHand());
        ((HollowProperty)AlchemancyProperties.HOLLOW.get()).setData(event.getItemStack(), michael.getItemInHand(event.getHand()));
        if (result.consumesAction()) {
            event.setCancellationResult(result);
        }
        event.setCanceled(true);
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        Level level = event.getLevel();
        Player player = event.getPlayer();
        ItemStack stored = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(event.getItemStack());
        if (stored.isEmpty()) {
            return;
        }
        Player michael = CommonUtils.createFakePlayer(level, player == null ? FAKE_GAME_PROFILE : player.getGameProfile());
        michael.moveTo(player.position(), player.getYRot(), player.getXRot());
        michael.setYHeadRot(player.getYHeadRot());
        michael.setPose(player.getPose());
        michael.setItemInHand(event.getHand(), stored.copy());
        UseOnContext context = event.getUseOnContext();
        context = new UseOnContext(level, michael, context.getHand(), stored, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside()));
        InteractionResult result = DispensingProperty.useItemOnBlock(michael, event.getHand(), context);
        if (!result.consumesAction()) {
            result = DispensingProperty.useItem(michael, event.getHand());
        }
        ((HollowProperty)AlchemancyProperties.HOLLOW.get()).setData(event.getItemStack(), context.getItemInHand());
        if (result.consumesAction()) {
            event.setCancellationResult(DispensingProperty.result(result));
        }
        event.setCanceled(true);
    }

    public static InteractionResult useItem(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown(itemstack.getItem())) {
            return InteractionResult.PASS;
        }
        InteractionResult cancelResult = CommonHooks.onItemRightClick((Player)player, (InteractionHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        InteractionResultHolder interactionresultholder = itemstack.use(player.level(), player, hand);
        ItemStack itemstack1 = (ItemStack)interactionresultholder.getObject();
        if (itemstack1 != itemstack) {
            player.setItemInHand(hand, itemstack1);
        }
        return interactionresultholder.getResult();
    }

    public static InteractionResult useItemOnBlock(Player player, InteractionHand hand, UseOnContext context) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown(itemstack.getItem())) {
            return InteractionResult.PASS;
        }
        UseItemOnBlockEvent event = (UseItemOnBlockEvent)NeoForge.EVENT_BUS.post((Event)new UseItemOnBlockEvent(context, UseItemOnBlockEvent.UsePhase.ITEM_AFTER_BLOCK));
        if (event.isCanceled()) {
            return event.getCancellationResult().result();
        }
        return CommonHooks.onPlaceItemIntoWorld((UseOnContext)context);
    }

    public static ItemInteractionResult result(InteractionResult result) {
        return switch (result) {
            default -> throw new MatchException(null, null);
            case InteractionResult.SUCCESS, InteractionResult.SUCCESS_NO_ITEM_USED -> ItemInteractionResult.SUCCESS;
            case InteractionResult.CONSUME -> ItemInteractionResult.CONSUME;
            case InteractionResult.CONSUME_PARTIAL -> ItemInteractionResult.CONSUME_PARTIAL;
            case InteractionResult.PASS -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
        };
    }

    @Override
    public int getPriority() {
        return -50;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 12539049;
    }
}

