/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.BucketingProperty;
import net.cibernet.alchemancy.properties.CapturingProperty;
import net.cibernet.alchemancy.properties.EncapsulatingProperty;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class DrippingProperty
extends Property {
    @Override
    public int getColor(ItemStack stack) {
        return 10521969;
    }

    @Override
    public void onAttack(@Nullable Entity user, ItemStack weapon, DamageSource damageSource, LivingEntity target) {
        DrippingProperty.drip(target.level(), user, (Entity)target, weapon);
    }

    @Override
    public void onDamageReceived(LivingEntity user, ItemStack weapon, EquipmentSlot slot, DamageSource damageSource) {
        DrippingProperty.drip(user.level(), (Entity)user, (Entity)user, weapon);
    }

    public static boolean drip(@javax.annotation.Nullable Level level, Entity user, @javax.annotation.Nullable Entity target, ItemStack stack) {
        Player player;
        if (target == null && user == null) {
            return false;
        }
        if (target == null) {
            target = user;
        }
        return ((BucketingProperty)AlchemancyProperties.BUCKETING.get()).placeLiquid(level, target.blockPosition(), stack, target instanceof Player ? (player = (Player)target) : null, null) || user != null && ((HollowProperty)AlchemancyProperties.HOLLOW.get()).dropItems(stack, user) || ((CapturingProperty)AlchemancyProperties.CAPTURING.get()).releaseMob(level, stack, target.position(), null) || ((EncapsulatingProperty)AlchemancyProperties.ENCAPSULATING.get()).attemptPlaceBlock(level, target.blockPosition(), stack, user);
    }

    @Override
    @Nullable
    public ItemInteractionResult onRootedRightClick(RootedItemBlockEntity root, Player user, InteractionHand hand, BlockHitResult hitResult) {
        return DrippingProperty.canMilkItem(root.getItem()) && DrippingProperty.attemptMilk(user, hand) ? ItemInteractionResult.sidedSuccess((boolean)user.level().isClientSide) : super.onRootedRightClick(root, user, hand, hitResult);
    }

    @SubscribeEvent
    private static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EquipmentSlot[] equipmentSlotArray = event.getTarget();
        if (equipmentSlotArray instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)equipmentSlotArray;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack;
                if (!slot.isArmor() || !DrippingProperty.canMilkItem(stack = target.getItemBySlot(slot)) || !DrippingProperty.attemptMilk(event.getEntity(), event.getHand())) continue;
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getEntity().level().isClientSide));
                event.setCanceled(true);
                return;
            }
        }
    }

    private static boolean canMilkItem(ItemStack stack) {
        return InfusedPropertiesHelper.hasInfusedProperty(stack, AlchemancyProperties.DRIPPING) && InfusedPropertiesHelper.hasInfusedProperty(stack, AlchemancyProperties.CALCAREOUS);
    }

    private static boolean attemptMilk(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.BUCKET)) {
            player.playSound((SoundEvent)AlchemancySoundEvents.CALCAREOUS_MILK.value(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)Items.MILK_BUCKET.getDefaultInstance());
            player.setItemInHand(hand, itemstack1);
            return true;
        }
        return false;
    }
}

