/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.AssembleProperty;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EarlyAssemblingProperty
extends Property {
    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        return dataType == DataComponents.MAX_STACK_SIZE ? Integer.valueOf(1) : data;
    }

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        if (source instanceof Player) {
            Player player = (Player)source;
            EarlyAssemblingProperty.craftItem(player, stack, null);
        }
    }

    @Override
    public void onStackedOverMe(ItemStack carriedItem, ItemStack stack, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (clickAction != ClickAction.SECONDARY) {
            return;
        }
        isCancelled.set(true);
        ItemStack craftedItem = EarlyAssemblingProperty.craftItem(player, stack, carriedItem);
        if (craftedItem == null) {
            return;
        }
        if (carriedItem.isEmpty()) {
            carriedSlot.set(craftedItem);
        } else {
            carriedItem.setCount(carriedItem.getCount() + craftedItem.getCount());
        }
    }

    @Override
    @Nullable
    public ItemInteractionResult onRootedRightClick(RootedItemBlockEntity root, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (EarlyAssemblingProperty.craftItem(player, root.getItem(), null) != null) {
            return ItemInteractionResult.SUCCESS;
        }
        return null;
    }

    @Nullable
    private static ItemStack craftItem(Player player, ItemStack toCraft, @Nullable ItemStack constraintTo) {
        HashMap<CraftingRecipe, NonNullList> acceptedRecipes = new HashMap<CraftingRecipe, NonNullList>();
        Level level = player.level();
        RegistryAccess registryAccess = level.registryAccess();
        List<RecipeHolder<CraftingRecipe>> availableRecipes = AssembleProperty.getRecipesMatchingOutput(toCraft, level);
        for (RecipeHolder<CraftingRecipe> craftingRecipe : availableRecipes) {
            NonNullList acceptedSlots = NonNullList.withSize((int)player.getInventory().getContainerSize(), (Object)0);
            if (constraintTo != null) {
                ItemStack result = ((CraftingRecipe)craftingRecipe.value()).getResultItem((HolderLookup.Provider)registryAccess);
                if (!constraintTo.isEmpty() && result.getCount() + constraintTo.getCount() > constraintTo.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)constraintTo)) continue;
            }
            boolean accepted = true;
            for (Ingredient ingredient : ((CraftingRecipe)craftingRecipe.value()).getIngredients()) {
                if (ingredient.isEmpty()) continue;
                boolean hasIngredient = false;
                for (int i = 0; i < acceptedSlots.size(); ++i) {
                    ItemStack inventoryStack = player.getInventory().getItem(i);
                    ItemStack storedItem = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(inventoryStack);
                    if (!storedItem.isEmpty()) {
                        inventoryStack = storedItem;
                    }
                    if (toCraft == inventoryStack || InfusedPropertiesHelper.hasProperty(inventoryStack, AlchemancyProperties.ASSEMBLING) || (Integer)acceptedSlots.get(i) >= inventoryStack.getCount() || !ingredient.test(inventoryStack)) continue;
                    hasIngredient = true;
                    acceptedSlots.set(i, (Object)((Integer)acceptedSlots.get(i) + 1));
                    break;
                }
                if (hasIngredient) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            acceptedRecipes.put((CraftingRecipe)craftingRecipe.value(), acceptedSlots);
        }
        if (acceptedRecipes.isEmpty()) {
            return null;
        }
        CraftingRecipe selected = (CraftingRecipe)acceptedRecipes.keySet().stream().toList().get(player.getRandom().nextInt(acceptedRecipes.size()));
        NonNullList selectedList = (NonNullList)acceptedRecipes.get(selected);
        ItemStack resultItem = selected.getResultItem((HolderLookup.Provider)registryAccess).copy();
        Inventory inventory = player.getInventory();
        if (constraintTo == null) {
            ItemStack stackInSlot;
            ArrayList<Integer> checkedSlots = new ArrayList<Integer>();
            for (int count = resultItem.getCount(); count > 0; count -= stackInSlot.getMaxStackSize() - stackInSlot.getCount()) {
                int slot = EarlyAssemblingProperty.getSlotWithRemainingSpace(player.getInventory(), resultItem, checkedSlots);
                if (slot == -1) {
                    return null;
                }
                checkedSlots.add(slot);
                stackInSlot = inventory.getItem(slot);
            }
            inventory.add(resultItem);
        }
        for (int slotToShrink = 0; slotToShrink < player.getInventory().getContainerSize(); ++slotToShrink) {
            if ((Integer)selectedList.get(slotToShrink) <= 0 || ((HollowProperty)AlchemancyProperties.HOLLOW.get()).shrinkContents(player.getInventory().getItem(slotToShrink), (Integer)selectedList.get(slotToShrink))) continue;
            inventory.removeItem(slotToShrink, ((Integer)selectedList.get(slotToShrink)).intValue());
        }
        return resultItem;
    }

    private static int getSlotWithRemainingSpace(Inventory inventory, ItemStack stack, List<Integer> alreadyChecked) {
        if (!alreadyChecked.contains(inventory.selected) && EarlyAssemblingProperty.hasRemainingSpaceForItem(inventory, inventory.getItem(inventory.selected), stack)) {
            return inventory.selected;
        }
        if (!alreadyChecked.contains(40) && EarlyAssemblingProperty.hasRemainingSpaceForItem(inventory, inventory.getItem(40), stack)) {
            return 40;
        }
        for (int i = 0; i < inventory.items.size(); ++i) {
            if (alreadyChecked.contains(i) || !EarlyAssemblingProperty.hasRemainingSpaceForItem(inventory, (ItemStack)inventory.items.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    private static boolean hasRemainingSpaceForItem(Inventory inventory, ItemStack destination, ItemStack origin) {
        return !destination.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)destination, (ItemStack)origin) && destination.isStackable() && destination.getCount() < inventory.getMaxStackSize(destination);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 2877951;
    }
}

