/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import java.util.Optional;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class EdibleProperty
extends Property {
    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        if (dataType == DataComponents.FOOD) {
            if (data == null) {
                return new FoodProperties(2, 0.5f, true, 1.6f, Optional.empty(), List.of());
            }
            if (data instanceof FoodProperties) {
                FoodProperties foodProperties = (FoodProperties)data;
                return new FoodProperties((int)((float)foodProperties.nutrition() * 1.5f), foodProperties.saturation() * 1.25f, true, foodProperties.eatSeconds(), foodProperties.usingConvertsTo(), foodProperties.effects());
            }
        }
        return super.modifyDataComponent(stack, dataType, data);
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.DEAD)) {
            event.getEntity().startUsingItem(event.getHand());
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }

    @Override
    public boolean onFinishUsingItem(LivingEntity user, Level level, ItemStack stack) {
        ItemStack food = stack.copy();
        if (this.damageItem((Entity)user, stack, EquipmentSlot.MAINHAND, 10)) {
            user.eat(level, food);
            return true;
        }
        return false;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 0xFF7777;
    }
}

