/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Optional;
import javax.annotation.Nullable;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

public class EncapsulatingProperty
extends Property
implements IDataHolder<BlockData> {
    private static final BlockData DEFAULT = new BlockData(Blocks.AIR.defaultBlockState(), new CompoundTag());

    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        return dataType == DataComponents.MAX_STACK_SIZE ? Integer.valueOf(1) : data;
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockData data = (BlockData)this.getData(event.getItemStack());
        if (event.isCanceled() || level.isClientSide()) {
            return;
        }
        if (data.blockState.isAir()) {
            if (this.pickUpBlock(level, pos, event.getItemStack(), (Entity)event.getPlayer())) {
                event.setCancellationResult(ItemInteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getPlayer() != null) {
                event.getPlayer().displayClientMessage((Component)Component.translatable((String)"property.alchemancy.encapsulating.cannot_store", (Object[])new Object[]{level.getBlockState(pos).getBlock().getName()}).withStyle(ChatFormatting.RED), true);
            }
        } else {
            if (event.getFace() != null && !level.getBlockState(pos).canBeReplaced()) {
                pos = pos.relative(event.getFace());
            }
            if (this.attemptPlaceBlock(level, pos, data, event.getItemStack(), (Entity)event.getPlayer())) {
                event.setCancellationResult(ItemInteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        ServerLevel level = blockSource.level();
        BlockPos pos = blockSource.pos().relative(direction);
        BlockData data = (BlockData)this.getData(stack);
        if (data.blockState.isAir()) {
            if (this.pickUpBlock((Level)level, pos, stack, null)) {
                InfusionPropertyDispenseBehavior.playDefaultParticles(blockSource, direction);
                return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
            }
        } else if (this.attemptPlaceBlock((Level)level, pos, data, stack, null)) {
            InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
            return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
        }
        return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
    }

    @Override
    public void onEntityItemDestroyed(ItemStack stack, Entity itemEntity, DamageSource damageSource) {
        block3: {
            block2: {
                if (stack.has(DataComponents.INTANGIBLE_PROJECTILE)) break block2;
                if (!(itemEntity instanceof AbstractArrow)) break block3;
                AbstractArrow arrow = (AbstractArrow)itemEntity;
                if (arrow.pickup != AbstractArrow.Pickup.DISALLOWED) break block3;
            }
            return;
        }
        this.attemptPlaceBlock(itemEntity.level(), itemEntity.blockPosition(), (BlockData)this.getData(stack), stack, null);
    }

    public boolean pickUpBlock(Level level, BlockPos pos, ItemStack stack, @Nullable Entity user) {
        Player player;
        BlockEntity blockEntity;
        BlockState state = level.getBlockState(pos);
        if (state.isAir() || state.getDestroySpeed((BlockGetter)level, pos) < 0.0f || state.is(AlchemancyTags.Blocks.CANNOT_ENCAPSULATE)) {
            return false;
        }
        if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.below();
            state = level.getBlockState(pos);
        }
        if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.BED_PART)) {
            if (state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.BED_PART) == BedPart.HEAD) {
                state = level.getBlockState(pos.relative(((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BedBlock.FACING)).getOpposite()));
            } else {
                pos = pos.relative((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BedBlock.FACING));
            }
        }
        if ((blockEntity = level.getBlockEntity(pos)) != null) {
            level.removeBlockEntity(pos);
        }
        if (!InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.NULLIFIER)) {
            this.setData(stack, state, blockEntity);
        }
        level.removeBlock(pos, false);
        level.levelEvent(user instanceof Player ? (player = (Player)user) : null, 2001, pos, Block.getId((BlockState)state));
        level.playSound(null, pos, state.getSoundType((LevelReader)level, pos, user).getBreakSound(), SoundSource.BLOCKS, 1.0f, 0.5f);
        return true;
    }

    private static BlockState fixChestBlockstate(Level level, BlockPos pos, BlockState state) {
        if (!state.hasProperty((net.minecraft.world.level.block.state.properties.Property)ChestBlock.TYPE)) {
            return state;
        }
        ChestType chestType = (ChestType)state.getValue((net.minecraft.world.level.block.state.properties.Property)ChestBlock.TYPE);
        if (chestType == ChestType.SINGLE) {
            return (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE);
        }
        BlockState connectedBlock = level.getBlockState(pos.relative(ChestBlock.getConnectedDirection((BlockState)state)));
        if (!connectedBlock.is(state.getBlock())) {
            return (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE);
        }
        if (connectedBlock.getValue((net.minecraft.world.level.block.state.properties.Property)ChestBlock.TYPE) != chestType.getOpposite()) {
            return state;
        }
        return (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE);
    }

    public boolean attemptPlaceBlock(Level level, BlockPos pos, ItemStack source, @Nullable Entity user) {
        return this.attemptPlaceBlock(level, pos, (BlockData)this.getData(source), source, user);
    }

    public boolean attemptPlaceBlock(Level level, BlockPos pos, BlockData data, ItemStack source, @Nullable Entity user) {
        LivingEntity living;
        BlockState oldState = level.getBlockState(pos);
        BlockState state = EncapsulatingProperty.fixChestBlockstate(level, pos, data.blockState());
        if (!oldState.canBeReplaced() || !state.canSurvive((LevelReader)level, pos) && !state.is(AlchemancyTags.Blocks.ENCAPSULATING_ALWAYS_PLACES)) {
            return false;
        }
        if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && !level.getBlockState(pos.relative(((DoubleBlockHalf)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).getDirectionToOther())).canBeReplaced()) {
            return false;
        }
        if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.BED_PART) && !level.getBlockState(pos.relative(state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.BED_PART) == BedPart.HEAD ? ((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite() : (Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING))).canBeReplaced()) {
            return false;
        }
        level.setBlockAndUpdate(pos, state);
        state.getBlock().setPlacedBy(level, pos, state, user instanceof LivingEntity ? (living = (LivingEntity)user) : null, ItemStack.EMPTY);
        BlockEntity blockEntity = this.createBlockEntity(pos, data);
        if (blockEntity != null) {
            level.setBlockEntity(blockEntity);
        }
        level.playSound(null, pos, state.getSoundType((LevelReader)level, pos, user).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.5f);
        this.setData(source, this.getDefaultData());
        return true;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 0x976997;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        Component name = super.getDisplayText(stack);
        BlockState storedBlock = ((BlockData)this.getData((ItemStack)stack)).blockState;
        if (!storedBlock.isAir()) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, storedBlock.getBlock().getName()}).withColor(this.getColor(stack));
        }
        return name;
    }

    @Nullable
    public BlockEntity createBlockEntity(BlockPos pos, ItemStack dataItem) {
        return this.createBlockEntity(pos, (BlockData)this.getData(dataItem));
    }

    @Nullable
    public BlockEntity createBlockEntity(BlockPos pos, BlockData data) {
        return this.createBlockEntity(data.blockState, pos, data.blockEntityData);
    }

    @Nullable
    public BlockEntity createBlockEntity(BlockState state, BlockPos pos, CompoundTag data) {
        EntityBlock entityBlock;
        BlockEntity result;
        Block block = state.getBlock();
        if (block instanceof EntityBlock && (result = (entityBlock = (EntityBlock)block).newBlockEntity(pos, state)) != null) {
            result.loadCustomOnly(data, (HolderLookup.Provider)CommonUtils.registryAccessStatic());
            return result;
        }
        return null;
    }

    public void setData(ItemStack stack, BlockState state, @Nullable BlockEntity blockEntity) {
        IDataHolder.super.setData(stack, new BlockData(state, blockEntity == null ? new CompoundTag() : blockEntity.saveCustomOnly((HolderLookup.Provider)CommonUtils.registryAccessStatic())));
    }

    @Override
    public BlockData readData(CompoundTag tag) {
        RegistryAccess registryAccess;
        Optional block;
        if (tag.contains("block_id", 8) && (block = (registryAccess = CommonUtils.registryAccessStatic()).lookupOrThrow(Registries.BLOCK).get(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)tag.getString("block_id"))))).isPresent()) {
            BlockState state = ((Block)((Holder.Reference)block.get()).value()).defaultBlockState();
            if (tag.contains("block_state", 10)) {
                StateDefinition stateDefinition = state.getBlock().getStateDefinition();
                CompoundTag blockStateTag = tag.getCompound("block_state");
                for (String statePropertyName : blockStateTag.getAllKeys()) {
                    net.minecraft.world.level.block.state.properties.Property stateProperty = stateDefinition.getProperty(statePropertyName);
                    if (stateProperty == null) continue;
                    state = EncapsulatingProperty.updateState(state, stateProperty, blockStateTag.getString(statePropertyName));
                }
            }
            return new BlockData(state, tag.getCompound("block_entity"));
        }
        return this.getDefaultData();
    }

    @Override
    public CompoundTag writeData(final BlockData data) {
        return new CompoundTag(){
            {
                RegistryAccess registryAccess = CommonUtils.registryAccessStatic();
                if (!data.blockEntityData.isEmpty()) {
                    this.put("block_entity", (Tag)data.blockEntityData);
                }
                if (!data.blockState.isAir()) {
                    BlockState state = data.blockState;
                    if (!state.getValues().isEmpty()) {
                        CompoundTag statesTag = new CompoundTag();
                        for (net.minecraft.world.level.block.state.properties.Property stateProperty : state.getValues().keySet()) {
                            statesTag.putString(stateProperty.getName(), EncapsulatingProperty.this.getStateValueName(stateProperty, state));
                        }
                        this.put("block_state", (Tag)statesTag);
                    }
                    this.putString("block_id", state.getBlockHolder().getKey().location().toString());
                }
            }
        };
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, net.minecraft.world.level.block.state.properties.Property<T> property, String propertyName) {
        return property.getValue(propertyName).map(p_330629_ -> (BlockState)state.setValue(property, p_330629_)).orElse(state);
    }

    private <T extends Comparable<T>> String getStateValueName(net.minecraft.world.level.block.state.properties.Property<T> property, BlockState state) {
        return property.getName(state.getValue(property));
    }

    @Override
    public BlockData getDefaultData() {
        return DEFAULT;
    }

    public record BlockData(BlockState blockState, CompoundTag blockEntityData) {
    }
}

