/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.BrittleProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

public class EnderProperty
extends Property {
    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        Level level = user.level();
        if (level.isClientSide()) {
            return;
        }
        if (user.isInWaterOrRain() && this.teleport(user, level)) {
            this.damageItem(stack, user, slot);
            return;
        }
        for (EquipmentSlot slotToCheck : EquipmentSlot.values()) {
            if (!InfusedPropertiesHelper.hasProperty(user.getItemBySlot(slotToCheck), AlchemancyProperties.WET) || !this.teleport(user, level)) continue;
            this.damageItem(stack, user, slot);
        }
    }

    @Override
    public boolean onFinishUsingItem(LivingEntity user, Level level, ItemStack stack) {
        if (!level.isClientSide()) {
            this.teleport(user, level);
        }
        return false;
    }

    @Override
    public void onActivation(Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        if (!target.level().isClientSide() && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            this.teleport(living, target.level());
        }
    }

    private void damageItem(ItemStack stack, LivingEntity entity, EquipmentSlot slot) {
        if (stack.isDamageableItem()) {
            this.damageItem((Entity)entity, stack, slot, 10);
        } else if (entity.getRandom().nextBoolean()) {
            this.consumeItem((Entity)entity, stack, slot);
        }
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (projectile.isRemoved() && InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SHATTERING)) {
            if (rayTraceResult.getType() == HitResult.Type.ENTITY && rayTraceResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
                this.onActivation((Entity)projectile, entityHitResult.getEntity(), stack);
            }
            return;
        }
        EnderProperty.playParticles(projectile.level(), projectile.position(), projectile.getRandom());
        Level level = projectile.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverlevel = (ServerLevel)level;
            if (!projectile.isRemoved() && (entity = projectile.getOwner()) != null && EnderProperty.isAllowedToTeleportOwner(entity, (Level)serverlevel)) {
                if (entity.isPassenger()) {
                    entity.unRide();
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity;
                    if (serverplayer.connection.isAcceptingMessages() && !event.isCanceled()) {
                        Endermite endermite;
                        if (projectile.getRandom().nextFloat() < 0.05f && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (endermite = (Endermite)EntityType.ENDERMITE.create((Level)serverlevel)) != null) {
                            endermite.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                            serverlevel.addFreshEntity((Entity)endermite);
                        }
                        entity.changeDimension(new DimensionTransition(serverlevel, projectile.position(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                        entity.resetFallDistance();
                        serverplayer.resetCurrentImpulseContext();
                        entity.hurt(projectile.damageSources().fall(), 5.0f);
                        EnderProperty.playSound((Level)serverlevel, projectile.position());
                    }
                } else {
                    entity.changeDimension(new DimensionTransition(serverlevel, projectile.position(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                    entity.resetFallDistance();
                    EnderProperty.playSound((Level)serverlevel, projectile.position());
                }
                BrittleProperty.breakProjectile(stack, projectile);
            }
        }
    }

    public static void playParticles(Level level, Vec3 pos, RandomSource randomSource) {
        for (int i = 0; i < 32; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, pos.x(), pos.y() + randomSource.nextDouble() * 2.0, pos.z(), randomSource.nextGaussian(), 0.0, randomSource.nextGaussian());
        }
    }

    public static void playSound(Level level, Vec3 pos) {
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    private static boolean isAllowedToTeleportOwner(Entity entity, Level level) {
        if (entity.level().dimension() == level.dimension()) {
            boolean bl;
            if (!(entity instanceof LivingEntity)) {
                bl = entity.isAlive();
            } else {
                LivingEntity livingentity = (LivingEntity)entity;
                bl = livingentity.isAlive() && !livingentity.isSleeping();
            }
            return bl;
        }
        return entity.canUsePortal(true);
    }

    boolean teleport(LivingEntity entityLiving, Level level) {
        for (int i = 0; i < 16; ++i) {
            double d0 = entityLiving.getX() + (entityLiving.getRandom().nextDouble() - 0.5) * 16.0;
            double d1 = Mth.clamp((double)(entityLiving.getY() + (double)(entityLiving.getRandom().nextInt(16) - 8)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + ((ServerLevel)level).getLogicalHeight() - 1));
            double d2 = entityLiving.getZ() + (entityLiving.getRandom().nextDouble() - 0.5) * 16.0;
            if (entityLiving.isPassenger()) {
                entityLiving.stopRiding();
            }
            Vec3 vec3 = entityLiving.position();
            EntityTeleportEvent.ChorusFruit event = EventHooks.onChorusFruitTeleport((LivingEntity)entityLiving, (double)d0, (double)d1, (double)d2);
            if (event.isCanceled()) {
                return false;
            }
            if (!entityLiving.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
            level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)entityLiving));
            SoundSource soundsource = entityLiving.getSoundSource();
            SoundEvent soundevent = entityLiving instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
            level.playSound(null, entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), soundevent, soundsource);
            entityLiving.resetFallDistance();
            if (entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                player.resetCurrentImpulseContext();
            }
            return true;
        }
        return false;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 13369594;
    }
}

