/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.AbstractTimerProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.cibernet.alchemancy.util.RedstoneSources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class EnergizedProperty
extends AbstractTimerProperty {
    private static final ResourceLocation SPEED_MOD_KEY = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"energized_property_modifier");
    private static final long ENERGIZED_DURATION = 1200L;

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        BlockPos pos;
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.INTERACTABLE)) {
            return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
        }
        ServerLevel level = blockSource.level();
        BlockState state = level.getBlockState(pos = blockSource.pos().relative(direction));
        if (!state.canRedstoneConnectTo((BlockGetter)level, pos, direction)) {
            return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
        }
        EnergizedProperty.powerBlock(blockSource.level(), pos, 0.46666667f, direction);
        InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
        return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        AttributeMap attributeMap = player.getAttributes();
        float energizedValue = 0.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = player.getItemBySlot(slot);
            if (!InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.ENERGIZED)) continue;
            energizedValue += ((EnergizedProperty)AlchemancyProperties.ENERGIZED.get()).getEnergizedTime(stack);
        }
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(SPEED_MOD_KEY, (double)(energizedValue *= 0.35f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attributes.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(SPEED_MOD_KEY, (double)energizedValue, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attributes.put((Object)Attributes.BLOCK_BREAK_SPEED, (Object)new AttributeModifier(SPEED_MOD_KEY, (double)energizedValue, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attributeMap.removeAttributeModifiers((Multimap)attributes);
        if (energizedValue > 0.0f) {
            attributeMap.addTransientAttributeModifiers((Multimap)attributes);
        }
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        Level level;
        if (slot == EquipmentSlot.FEET && (level = user.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float strength = this.getEnergizedTime(stack);
            if (strength > 0.0f) {
                EnergizedProperty.powerBlock(serverLevel, user.blockPosition().below(), strength, Direction.UP);
            }
        }
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (rayTraceResult.getType() == HitResult.Type.BLOCK && rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            Level level = projectile.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EnergizedProperty.powerBlock(serverLevel, blockHitResult.getBlockPos(), 1.0f, blockHitResult.getDirection());
            }
        }
    }

    public static void powerBlock(ServerLevel level, BlockPos pos, float strength, Direction direction) {
        RedstoneSources.createSourceAt(level, pos, (int)Math.ceil(15.0f * strength), 10, direction);
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (InfusedPropertiesHelper.hasProperty(event.getItemStack(), AlchemancyProperties.INTERACTABLE)) {
                EnergizedProperty.powerBlock(serverLevel, event.getPos(), 1.0f, event.getFace());
            }
        }
    }

    @Override
    public void onActivationByBlock(Level level, BlockPos position, Entity target, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RedstoneSources.createSourceAt(serverLevel, position, 15, 20, Direction.DOWN);
        }
    }

    @Override
    public void onDamageReceived(LivingEntity user, ItemStack weapon, EquipmentSlot slot, DamageSource damageSource) {
        if (damageSource.is(AlchemancyTags.DamageTypes.SHOCK_DAMAGE)) {
            this.resetStartTimestamp(weapon);
        }
    }

    public float getEnergizedTime(ItemStack stack) {
        if ((Long)this.getData(stack) == 0L) {
            return 0.0f;
        }
        return 1L - Mth.clamp((long)(this.getElapsedTime(stack) / 1200L), (long)0L, (long)1L);
    }

    @Override
    public int getColor(ItemStack stack) {
        return FastColor.ARGB32.lerp((float)this.getEnergizedTime(stack), (int)7539712, (int)15081480);
    }
}

