/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import javax.annotation.Nullable;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.item.components.PropertyModifierComponent;
import net.cibernet.alchemancy.properties.MobEffectOnHitProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ExplodingProperty
extends Property {
    private final int color;
    final float critRadius;
    final float emergencyRadius;
    private final ExplosionConsumer explosion;

    public ExplodingProperty(int color, float critRadius, float emergencyRadius, ExplosionConsumer explosion) {
        this.color = color;
        this.critRadius = critRadius;
        this.emergencyRadius = emergencyRadius;
        this.explosion = explosion;
    }

    public static ExplosionConsumer destroyBlocks() {
        return (user, stack, target, level, radius) -> {
            Level.ExplosionInteraction interaction = EventHooks.canEntityGrief((Level)level, (Entity)user) ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
            level.explode((Entity)user, Explosion.getDefaultDamageSource((Level)level, (Entity)user), null, target.getX(), target.getEyeY(), target.getZ(), radius, InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.BURNING), interaction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
            target.hurt(Explosion.getDefaultDamageSource((Level)level, (Entity)user), radius * 14.0f + 1.0f);
        };
    }

    public static ExplosionConsumer gust() {
        return (user, stack, target, level, radius) -> level.explode(null, level.damageSources().explosion((Entity)user, (Entity)user), AbstractWindCharge.EXPLOSION_DAMAGE_CALCULATOR, target.getX(), target.getEyeY(), target.getZ(), radius, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST);
    }

    @Override
    public void onCriticalAttack(Player user, ItemStack weapon, Entity target) {
        this.explode((LivingEntity)user, target, EquipmentSlot.MAINHAND, PropertyModifierComponent.getOrElse(weapon, this.asHolder(), AlchemancyProperties.Modifiers.ATTACK_RADIUS, Float.valueOf(this.critRadius)).floatValue(), weapon);
    }

    @Override
    public void onDamageReceived(LivingEntity user, ItemStack weapon, EquipmentSlot slot, DamageSource damageSource) {
        if (slot.isArmor() && ExplodingProperty.entityLowOnHealth(user)) {
            this.explode(user, (Entity)user, slot, PropertyModifierComponent.getOrElse(weapon, this.asHolder(), AlchemancyProperties.Modifiers.EFFECT_RADIUS, Float.valueOf(this.emergencyRadius)).floatValue(), weapon);
        }
    }

    private void explode(LivingEntity entity, Entity target, EquipmentSlot slot, float radius, ItemStack stack) {
        Level level = target.level();
        if (!level.isClientSide) {
            this.explosion.apply(entity, stack, target, level, radius);
            ExplodingProperty.spawnLingeringCloud(level, stack, target.position());
            this.damageOrConsumeItem(target.level(), (Entity)entity, stack, slot, 20);
        }
    }

    private static void spawnLingeringCloud(Level level, ItemStack stack, Vec3 pos) {
        List<MobEffectInstance> collection = InfusedPropertiesHelper.getInfusedProperties(stack).stream().filter(p -> p.value() instanceof MobEffectOnHitProperty).map(p -> ((MobEffectOnHitProperty)p.value()).effect).toList();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(level, pos.x(), pos.y(), pos.z());
            areaeffectcloud.setRadius(2.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(10);
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.addEffect(new MobEffectInstance(mobeffectinstance));
            }
            level.addFreshEntity((Entity)areaeffectcloud);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return this.color;
    }

    public static interface ExplosionConsumer {
        public void apply(@Nullable LivingEntity var1, ItemStack var2, Entity var3, Level var4, float var5);
    }
}

