/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Random;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class FleetingProperty
extends Property {
    private static final Random random = new Random();
    private static float sparkColor = 0.0f;

    @Override
    public void onItemTossed(Player player, ItemStack stack, ItemEntity itemEntity, ItemTossEvent event) {
        itemEntity.getItem().setCount(0);
        event.setCanceled(true);
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (!level.isClientSide() && user.getRandom().nextFloat() < 0.002f) {
            stack.shrink(1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    private static void onClientTick(ClientTickEvent.Pre event) {
        sparkColor = random.nextFloat() < 0.05f ? 1.0f : Math.max(0.0f, sparkColor - 0.033333335f);
    }

    @Override
    public int getColor(ItemStack stack) {
        return FastColor.ARGB32.lerp((float)sparkColor, (int)1772571, (int)13761279);
    }
}

