/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class FrostedProperty
extends Property {
    @Override
    public int getColor(ItemStack stack) {
        return 6738431;
    }

    @Override
    public void onAttack(Entity user, ItemStack weapon, DamageSource damageSource, LivingEntity target) {
        target.setTicksFrozen(Math.max(target.getTicksFrozen(), target.getTicksRequiredToFreeze() * 2));
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (slot.isArmor()) {
            user.setTicksFrozen(user.getTicksFrozen() + 3);
        }
    }

    @Override
    public void onRootedTick(RootedItemBlockEntity root, List<LivingEntity> entitiesInBounds) {
        for (LivingEntity entity : entitiesInBounds) {
            entity.setTicksFrozen(entity.getTicksFrozen() + 3);
        }
    }

    @Override
    public void onRootedAnimateTick(RootedItemBlockEntity root, RandomSource random) {
        FrostedProperty.playRootedParticles(root, random, (ParticleOptions)ParticleTypes.SNOWFLAKE);
    }
}

