/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.blocks.GlowingOrbBlock;
import net.cibernet.alchemancy.client.particle.options.SparkParticleOptions;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class GlowRingProperty
extends Property {
    public static final ParticleOptions PARTICLES = new SparkParticleOptions(Vec3.fromRGB24((int)0xFFFFBA).toVector3f(), 0.85f);

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        BlockPos pos;
        Level level = user.level();
        if (level.getBrightness(LightLayer.BLOCK, pos = user.blockPosition()) <= 7 && level.getBlockState(pos).canBeReplaced()) {
            Player player;
            BlockState state = ((GlowingOrbBlock)((Object)AlchemancyBlocks.GLOWING_ORB.get())).getStateForPlacement(new BlockPlaceContext(level, user instanceof Player ? (player = (Player)user) : null, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(pos.getCenter(), Direction.UP, pos, false)));
            level.setBlock(pos, state == null ? ((GlowingOrbBlock)((Object)AlchemancyBlocks.GLOWING_ORB.get())).defaultBlockState() : state, 11);
        }
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        BlockPos pos;
        Level level = projectile.level();
        if (level.getBrightness(LightLayer.BLOCK, pos = projectile.blockPosition()) <= 7 && level.getBlockState(pos).canBeReplaced()) {
            BlockState state = ((GlowingOrbBlock)((Object)AlchemancyBlocks.GLOWING_ORB.get())).getStateForPlacement(new BlockPlaceContext(level, null, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(pos.getCenter(), Direction.UP, pos, false)));
            level.setBlock(pos, state == null ? ((GlowingOrbBlock)((Object)AlchemancyBlocks.GLOWING_ORB.get())).defaultBlockState() : state, 11);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 0xFFFFBA;
    }

    @Override
    public boolean hasJournalEntry() {
        return false;
    }
}

