/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.item.components.PropertyModifierComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class HeadearProperty
extends Property {
    @Override
    public EquipmentSlot modifyWearableSlot(ItemStack stack, @Nullable EquipmentSlot originalSlot, @Nullable EquipmentSlot slot) {
        return EquipmentSlot.HEAD;
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PropertyModifierComponent.get(event.getItemStack(), this.asHolder(), AlchemancyProperties.Modifiers.ON_RIGHT_CLICK).booleanValue()) {
            Player player = event.getEntity();
            InteractionResultHolder<ItemStack> resultHolder = HeadearProperty.swapWithEquipmentSlot(event.getItemStack().getItem(), event.getLevel(), player, event.getHand());
            if (resultHolder.getResult().consumesAction()) {
                player.setItemInHand(event.getHand(), (ItemStack)resultHolder.getObject());
            }
            event.setCancellationResult(resultHolder.getResult());
            if (!(event.getItemStack().getItem() instanceof Equipable)) {
                player.level().playSeededSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_EQUIP_GENERIC, player.getSoundSource(), 1.0f, 1.0f, player.getRandom().nextLong());
            }
        }
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        if (currentResult != InfusionPropertyDispenseBehavior.DispenseResult.CONSUME && ArmorItem.dispenseArmor((BlockSource)blockSource, (ItemStack)stack)) {
            InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
            return InfusionPropertyDispenseBehavior.DispenseResult.CONSUME;
        }
        return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> swapWithEquipmentSlot(Item item, Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        EquipmentSlot equipmentslot = player.getEquipmentSlotForItem(itemstack);
        if (!player.canUseSlot(equipmentslot)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        ItemStack itemstack1 = player.getItemBySlot(equipmentslot);
        if (!(EnchantmentHelper.has((ItemStack)itemstack1, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !player.isCreative() || ItemStack.matches((ItemStack)itemstack, (ItemStack)itemstack1))) {
            if (!level.isClientSide()) {
                player.awardStat(Stats.ITEM_USED.get((Object)item));
            }
            ItemStack itemstack2 = itemstack1.isEmpty() ? itemstack : itemstack1.copyAndClear();
            ItemStack itemstack3 = player.isCreative() ? itemstack.copy() : itemstack.copyAndClear();
            player.setItemSlot(equipmentslot, itemstack3);
            return InteractionResultHolder.sidedSuccess((Object)itemstack2, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 14831476;
    }
}

