/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

public class HeavyProperty
extends Property {
    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity entity) {
        if (!entity.isNoGravity()) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile entity) {
        if (!entity.isNoGravity()) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -0.08, 0.0));
            entity.hasImpulse = true;
        }
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        block3: {
            block2: {
                if (!(user instanceof Player)) break block2;
                Player player = (Player)user;
                if (player.getAbilities().flying) break block3;
            }
            Vec3 slowDelta = user.getDeltaMovement().scale(0.5);
            user.setDeltaMovement(new Vec3(slowDelta.x, user.getDeltaMovement().y - 0.025, slowDelta.z));
            user.hasImpulse = true;
        }
    }

    @Override
    public void onFall(LivingEntity entity, ItemStack stack, EquipmentSlot slot, LivingFallEvent event) {
        if (slot == EquipmentSlot.FEET || slot == EquipmentSlot.BODY) {
            entity.playSound((SoundEvent)AlchemancySoundEvents.HEAVY.value(), Mth.lerp((float)(entity.fallDistance / 23.0f), (float)0.1f, (float)1.0f), Mth.lerp((float)(event.getDistance() / (float)entity.getMaxFallDistance()), (float)1.0f, (float)0.5f));
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 3490380;
    }
}

