/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class HollowProperty
extends Property
implements IDataHolder<ItemStack> {
    @Override
    public int getColor(ItemStack stack) {
        return 7360551;
    }

    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        return dataType == DataComponents.MAX_STACK_SIZE ? Integer.valueOf(1) : data;
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        if (currentResult != InfusionPropertyDispenseBehavior.DispenseResult.PASS) {
            return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
        }
        ItemStack storedStack = (ItemStack)this.getData(stack);
        if (!stack.isEmpty()) {
            DefaultDispenseItemBehavior.spawnItem((Level)blockSource.level(), (ItemStack)storedStack, (int)6, (Direction)direction, (Position)DispenserBlock.getDispensePosition((BlockSource)blockSource));
            this.setData(stack, this.getDefaultData());
            InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
            return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
        }
        return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
    }

    @Override
    public void onPickUpAnyItem(Player user, ItemStack stack, EquipmentSlot slot, ItemEntity itemToPickUp, boolean canPickUp, ItemEntityPickupEvent.Pre event) {
        if (!canPickUp) {
            return;
        }
        ItemStack storedStack = (ItemStack)this.getData(stack);
        ItemStack stackToPickUp = event.getItemEntity().getItem();
        int toPickUp = 0;
        if (storedStack.isEmpty()) {
            storedStack = stackToPickUp.copy();
            toPickUp = stackToPickUp.getCount();
            stackToPickUp.setCount(0);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)storedStack, (ItemStack)stackToPickUp)) {
            int mergeLimit = storedStack.getMaxStackSize() - storedStack.getCount();
            toPickUp = Math.min(storedStack.getMaxStackSize(), storedStack.getCount() + stackToPickUp.getCount());
            storedStack.setCount(toPickUp);
            stackToPickUp.shrink(mergeLimit);
        }
        if (toPickUp > 0) {
            this.playInsertSound((Entity)user);
            user.take((Entity)itemToPickUp, toPickUp);
            this.setData(stack, storedStack);
        }
    }

    @Override
    public void onStackedOverItem(ItemStack hollowItem, ItemStack carriedItem, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (isCancelled.get() || clickAction != ClickAction.SECONDARY) {
            return;
        }
        ItemStack storedStack = (ItemStack)this.getData(hollowItem);
        if (!storedStack.isEmpty()) {
            if (carriedItem.isEmpty()) {
                stackedOnSlot.set(storedStack);
                this.setData(hollowItem, this.getDefaultData());
                isCancelled.set(true);
                return;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)storedStack, (ItemStack)carriedItem)) {
                int mergeLimit = storedStack.getMaxStackSize() - storedStack.getCount();
                storedStack.setCount(Math.min(storedStack.getMaxStackSize(), storedStack.getCount() + carriedItem.getCount()));
                carriedItem.shrink(mergeLimit);
                this.setData(hollowItem, storedStack);
                stackedOnSlot.set(carriedItem);
                isCancelled.set(true);
            }
        }
        if (!carriedItem.isEmpty() && this.storeItem((Entity)player, hollowItem, carriedItem)) {
            stackedOnSlot.set(carriedItem);
            isCancelled.set(true);
        }
    }

    @Override
    public void onStackedOverMe(ItemStack carriedItem, ItemStack stackedOnItem, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (isCancelled.get() || clickAction != ClickAction.SECONDARY) {
            return;
        }
        ItemStack storedStack = (ItemStack)this.getData(stackedOnItem);
        if (!storedStack.isEmpty()) {
            if (carriedItem.isEmpty()) {
                carriedSlot.set(storedStack);
                this.setData(stackedOnItem, this.getDefaultData());
                isCancelled.set(true);
                return;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)storedStack, (ItemStack)carriedItem)) {
                int mergeLimit = storedStack.getMaxStackSize() - storedStack.getCount();
                storedStack.setCount(Math.min(storedStack.getMaxStackSize(), storedStack.getCount() + carriedItem.getCount()));
                carriedItem.shrink(mergeLimit);
                this.setData(stackedOnItem, storedStack);
                carriedSlot.set(carriedItem);
                isCancelled.set(true);
            }
        }
        if (!carriedItem.isEmpty() && this.storeItem((Entity)player, stackedOnItem, carriedItem)) {
            carriedSlot.set(carriedItem);
            isCancelled.set(true);
        }
    }

    public boolean storeItem(@Nullable Entity player, ItemStack hollowItem, ItemStack itemToPickUp) {
        ItemStack storedStack = (ItemStack)this.getData(hollowItem);
        if (this.canStore(hollowItem, itemToPickUp)) {
            if (storedStack.isEmpty()) {
                storedStack = itemToPickUp.copy();
                itemToPickUp.setCount(0);
            } else {
                int mergeLimit = storedStack.getMaxStackSize() - storedStack.getCount();
                storedStack.setCount(Math.min(storedStack.getMaxStackSize(), storedStack.getCount() + itemToPickUp.getCount()));
                itemToPickUp.shrink(mergeLimit);
            }
            if (player != null) {
                this.playInsertSound(player);
            }
            this.setData(hollowItem, storedStack);
            return true;
        }
        return false;
    }

    public boolean canStore(ItemStack hollowItem, ItemStack itemToPickUp) {
        ItemStack storedStack = (ItemStack)this.getData(hollowItem);
        return storedStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)storedStack, (ItemStack)itemToPickUp) && storedStack.getCount() + itemToPickUp.getCount() <= storedStack.getMaxStackSize();
    }

    public boolean isFull(ItemStack hollowItem) {
        ItemStack storedStack = (ItemStack)this.getData(hollowItem);
        return !storedStack.isEmpty() && storedStack.getCount() >= storedStack.getMaxStackSize();
    }

    private void playInsertSound(Entity entity) {
        entity.playSound((SoundEvent)AlchemancySoundEvents.HOLLOW_INSERT.value(), 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound((SoundEvent)AlchemancySoundEvents.HOLLOW_DROP_CONTENTS.value(), 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    @Override
    public void onRootedTick(RootedItemBlockEntity root, List<LivingEntity> entitiesInBounds) {
        ItemStack rootStack = root.getItem();
        if (!this.isFull(rootStack)) {
            Level level = root.getLevel();
            BlockPos pos = root.getBlockPos();
            List items = level.getEntitiesOfClass(ItemEntity.class, root.getBlockState().getShape((BlockGetter)level, pos).bounds().move(pos));
            for (ItemEntity itemEntity : items) {
                ItemStack itemToPickUp = itemEntity.getItem();
                if (itemEntity.isRemoved() || !this.storeItem(null, rootStack, itemToPickUp) || itemToPickUp.getCount() > 0) continue;
                itemEntity.discard();
                break;
            }
        }
    }

    @Override
    @Nullable
    public ItemInteractionResult onRootedRightClick(RootedItemBlockEntity root, Player user, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = user.getItemInHand(hand);
        if (heldItem.isEmpty()) {
            user.addItem((ItemStack)this.getData(root.getItem()));
            this.setData(root.getItem(), this.getDefaultData());
            return ItemInteractionResult.sidedSuccess((boolean)user.level().isClientSide());
        }
        return this.storeItem((Entity)user, root.getItem(), heldItem) ? ItemInteractionResult.sidedSuccess((boolean)user.level().isClientSide()) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getLevel().isClientSide() && !event.isCanceled()) {
            ItemStack stack = event.getItemStack();
            ItemStack storedStack = (ItemStack)this.getData(stack);
            if (!stack.isEmpty()) {
                if (event.getEntity().isShiftKeyDown()) {
                    ItemStack stackToDrop = storedStack.copy();
                    stackToDrop.setCount(1);
                    ItemEntity item = event.getEntity().drop(stackToDrop, true);
                    if (item != null) {
                        item.setDefaultPickUpDelay();
                    }
                    storedStack.shrink(1);
                    this.setData(stack, storedStack);
                    this.playDropContentsSound((Entity)event.getEntity());
                } else {
                    this.dropItems(stack, storedStack, (Entity)event.getEntity());
                }
            }
        }
    }

    public boolean dropItems(ItemStack hollowItem, Entity user) {
        return this.dropItems(hollowItem, (ItemStack)this.getData(hollowItem), user);
    }

    protected boolean dropItems(ItemStack hollowItem, ItemStack toDrop, Entity user) {
        if (toDrop.isEmpty()) {
            return false;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            ItemEntity item = player.drop(toDrop, true);
            if (item != null) {
                item.setDefaultPickUpDelay();
            }
        } else if (HollowProperty.nonPlayerDrop(user, toDrop, false, true) == null) {
            return false;
        }
        this.setData(hollowItem, ItemStack.EMPTY);
        this.playDropContentsSound(user);
        return true;
    }

    public static ItemEntity drop(Entity user, ItemStack droppedItem, boolean dropAround, boolean includeThrowerName) {
        if (user instanceof Player) {
            Player player = (Player)user;
            return player.drop(droppedItem, dropAround, includeThrowerName);
        }
        return HollowProperty.nonPlayerDrop(user, droppedItem, dropAround, includeThrowerName);
    }

    public static ItemEntity nonPlayerDrop(Entity user, ItemStack droppedItem, boolean dropAround, boolean includeThrowerName) {
        if (droppedItem.isEmpty()) {
            return null;
        }
        if (user.level().isClientSide && user instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)user;
            living.swing(InteractionHand.MAIN_HAND);
        }
        double d0 = user.getEyeY() - (double)0.3f;
        ItemEntity itementity = new ItemEntity(user.level(), user.getX(), d0, user.getZ(), droppedItem);
        itementity.setDefaultPickUpDelay();
        if (includeThrowerName) {
            itementity.setThrower(user);
        }
        RandomSource random = user.getRandom();
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            itementity.setDeltaMovement((double)(-Mth.sin((float)f1) * f), (double)0.2f, (double)(Mth.cos((float)f1) * f));
        } else {
            float f7 = 0.3f;
            float f8 = Mth.sin((float)(user.getXRot() * ((float)Math.PI / 180)));
            float f2 = Mth.cos((float)(user.getXRot() * ((float)Math.PI / 180)));
            float f3 = Mth.sin((float)(user.getYRot() * ((float)Math.PI / 180)));
            float f4 = Mth.cos((float)(user.getYRot() * ((float)Math.PI / 180)));
            float f5 = random.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * random.nextFloat();
            itementity.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (random.nextFloat() - random.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!user.level().isClientSide) {
            user.getCommandSenderWorld().addFreshEntity((Entity)itementity);
        }
        return itementity;
    }

    @Override
    public void onEntityItemDestroyed(ItemStack stack, Entity itemEntity, DamageSource damageSource) {
        ItemStack storedItem;
        block5: {
            block4: {
                if (stack.has(DataComponents.INTANGIBLE_PROJECTILE)) break block4;
                if (!(itemEntity instanceof AbstractArrow)) break block5;
                AbstractArrow arrow = (AbstractArrow)itemEntity;
                if (arrow.pickup != AbstractArrow.Pickup.DISALLOWED) break block5;
            }
            return;
        }
        if (!(storedItem = (ItemStack)this.getData(stack)).isEmpty()) {
            HollowProperty.onContainerDestroyed(itemEntity, List.of(storedItem));
            this.setData(stack, this.getDefaultData());
        }
    }

    public static void onContainerDestroyed(Entity container, Iterable<ItemStack> contents) {
        Level level = container.level();
        if (!level.isClientSide) {
            contents.forEach(p_352858_ -> level.addFreshEntity((Entity)new ItemEntity(level, container.getX(), container.getY(), container.getZ(), p_352858_)));
        }
    }

    @Override
    public int modifyDurabilityConsumed(ItemStack stack, ServerLevel level, @Nullable LivingEntity user, int originalAmount, int resultingAmount, RandomSource random) {
        if (user != null && stack.getMaxDamage() <= stack.getDamageValue() + resultingAmount) {
            this.dropItems(stack, (Entity)user);
        }
        return resultingAmount;
    }

    @Override
    public ItemStack readData(CompoundTag tag) {
        return tag.isEmpty() ? this.getDefaultData() : ItemStack.parse((HolderLookup.Provider)CommonUtils.registryAccessStatic(), (Tag)tag.getCompound("item")).orElse(this.getDefaultData());
    }

    @Override
    public CompoundTag writeData(final ItemStack data) {
        return new CompoundTag(this){
            {
                if (!data.isEmpty()) {
                    this.put("item", data.save((HolderLookup.Provider)CommonUtils.registryAccessStatic()));
                }
            }
        };
    }

    @Override
    public ItemStack combineData(@Nullable ItemStack currentData, ItemStack newData) {
        if (currentData == null || currentData.isEmpty()) {
            return newData;
        }
        if (ItemStack.matches((ItemStack)currentData, (ItemStack)newData)) {
            currentData.setCount(Math.min(currentData.getMaxStackSize(), currentData.getCount() + newData.getCount()));
        }
        return currentData;
    }

    @Override
    public ItemStack getDefaultData() {
        return ItemStack.EMPTY;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        Component name = super.getDisplayText(stack);
        ItemStack storedStack = (ItemStack)this.getData(stack);
        if (!storedStack.isEmpty()) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, Component.translatable((String)"property.detail.item_count", (Object[])new Object[]{storedStack.getHoverName(), storedStack.getCount()})}).withColor(this.getColor(stack));
        }
        return name;
    }

    public boolean shrinkContents(ItemStack hollowItem, int amount) {
        ItemStack storedItem = (ItemStack)this.getData(hollowItem);
        if (!hollowItem.isEmpty() && storedItem.getCount() >= amount) {
            storedItem.shrink(amount);
            this.setData(hollowItem, storedItem.isEmpty() ? ItemStack.EMPTY : storedItem);
            return true;
        }
        return false;
    }
}

