/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class HydrophobicProperty
extends Property
implements IDataHolder<Boolean> {
    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (user.isInWater() && !((Boolean)this.getData(stack)).booleanValue()) {
            HydrophobicProperty.activateByEntity((Entity)user, (Entity)user, stack);
        }
        this.setData(stack, Boolean.valueOf(user.isInWater()));
    }

    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity itemEntity) {
        if (itemEntity.isInWater() && !((Boolean)this.getData(stack)).booleanValue()) {
            HydrophobicProperty.activateByEntity((Entity)itemEntity, (Entity)itemEntity, stack);
        }
        this.setData(stack, Boolean.valueOf(itemEntity.isInWater()));
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        if (projectile.isInWater() && !((Boolean)this.getData(stack)).booleanValue()) {
            HydrophobicProperty.activateByEntity((Entity)projectile, (Entity)projectile, stack);
        }
        this.setData(stack, Boolean.valueOf(projectile.isInWater()));
    }

    @Override
    public int getColor(ItemStack stack) {
        return 3316691;
    }

    @Override
    public Boolean readData(CompoundTag tag) {
        return tag.getBoolean("in_water");
    }

    @Override
    public CompoundTag writeData(final Boolean data) {
        return new CompoundTag(this){
            {
                this.putBoolean("in_water", data);
            }
        };
    }

    @Override
    public Boolean getDefaultData() {
        return false;
    }
}

