/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.ArrayList;
import java.util.Optional;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;

public class ImprovedProperty
extends Property {
    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        Integer i;
        if (dataType == DataComponents.TOOL && data instanceof Tool) {
            Tool tool = (Tool)data;
            ArrayList<Tool.Rule> rules = new ArrayList<Tool.Rule>();
            for (Tool.Rule rule : tool.rules()) {
                if (!rule.correctForDrops().isPresent() || !((Boolean)rule.correctForDrops().get()).booleanValue()) continue;
                rules.add(new Tool.Rule(rule.blocks(), Optional.of(Float.valueOf(rule.speed().isPresent() ? Math.max(((Float)rule.speed().get()).floatValue(), 8.0f) : 8.0f)), rule.correctForDrops()));
            }
            rules.add(Tool.Rule.deniesDrops((TagKey)BlockTags.INCORRECT_FOR_DIAMOND_TOOL));
            return new Tool(rules, tool.defaultMiningSpeed(), tool.damagePerBlock());
        }
        if (dataType == DataComponents.MAX_DAMAGE && data instanceof Integer && (i = (Integer)data) < 1600) {
            return Math.max((Integer)data, Math.min(1600, (Integer)data * 2));
        }
        return super.modifyDataComponent(stack, dataType, data);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 4910553;
    }

    @Override
    public int getPriority() {
        return 100;
    }
}

