/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class InteractableProperty
extends Property {
    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled()) {
            ItemStack stack = event.getItemStack();
            InteractableProperty.activateByEntity((Entity)event.getEntity(), (Entity)event.getEntity(), stack);
            Player player = event.getEntity();
            if (player instanceof Player) {
                Player player2 = player;
                InteractableProperty.applyCooldown(player2, event.getItemStack());
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.isCanceled()) {
            ItemStack stack = event.getItemStack();
            InteractableProperty.activateByEntity((Entity)event.getEntity(), event.getTarget(), stack);
            Player player = event.getEntity();
            if (player instanceof Player) {
                Player player2 = player;
                InteractableProperty.applyCooldown(player2, event.getItemStack());
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static void applyCooldown(Player player, ItemStack stack, int amount) {
        ItemCooldowns cooldowns = player.getCooldowns();
        if (!cooldowns.isOnCooldown(stack.getItem())) {
            cooldowns.addCooldown(stack.getItem(), amount);
        }
    }

    protected static void applyCooldown(Player player, ItemStack stack) {
        InteractableProperty.applyCooldown(player, stack, 20);
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        BlockPos blockpos;
        ServerLevel serverlevel = blockSource.level();
        List list = serverlevel.getEntitiesOfClass(Entity.class, new AABB(blockpos = blockSource.pos().relative((Direction)blockSource.state().getValue((net.minecraft.world.level.block.state.properties.Property)DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
        if (!list.isEmpty()) {
            InteractableProperty.activateByBlock((Level)serverlevel, blockpos, (Entity)list.getFirst(), stack);
            InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
            return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
        }
        return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
    }

    @Override
    @Nullable
    public ItemInteractionResult onRootedRightClick(RootedItemBlockEntity root, Player user, InteractionHand hand, BlockHitResult hitResult) {
        InteractableProperty.activateByBlock(root, (Entity)user);
        return super.onRootedRightClick(root, user, hand, hitResult);
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            InteractableProperty.activateByEntity((Entity)projectile, ((EntityHitResult)rayTraceResult).getEntity(), stack);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 0xFF6366;
    }
}

