/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Random;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class LightningBoltProperty
extends Property {
    private static final Random random = new Random();
    private static float sparkColor = 0.0f;

    @Override
    public void onCriticalAttack(@Nullable Player user, ItemStack weapon, Entity target) {
        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(target.level());
        if (lightningbolt == null) {
            return;
        }
        lightningbolt.moveTo(target.position());
        lightningbolt.setCause(user instanceof ServerPlayer ? (ServerPlayer)user : null);
        target.level().addFreshEntity((Entity)lightningbolt);
        this.damageOrConsumeItem(target.level(), (Entity)user, weapon, EquipmentSlot.MAINHAND, 20);
    }

    @Override
    public int getColor(ItemStack stack) {
        return FastColor.ARGB32.lerp((float)sparkColor, (int)28325, (int)0xB5FFFF);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    private static void onClientTick(ClientTickEvent.Pre event) {
        sparkColor = random.nextFloat() < (sparkColor > 0.0f ? 0.075f : 0.025f) ? 1.0f : Math.max(0.0f, sparkColor - 0.033333335f);
    }
}

