/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.UUID;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

public class LoyalProperty
extends Property
implements IDataHolder<UUID> {
    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        if (projectile.level().isClientSide()) {
            return;
        }
        if (this.isReturning((Entity)projectile) && projectile.getOwner() != null) {
            Entity entity = projectile.getOwner();
            float i = 2.0f;
            Vec3 vec3 = entity.getEyePosition().subtract(projectile.position());
            double d0 = 0.05 * (double)i;
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d0)));
            projectile.hasImpulse = true;
        }
    }

    protected void dealArrowDamage(AbstractArrow arrow, Entity target) {
        boolean flag;
        Level level;
        float f = (float)arrow.getDeltaMovement().length();
        double d0 = arrow.getBaseDamage();
        Entity entity1 = arrow.getOwner();
        DamageSource damagesource = arrow.damageSources().arrow(arrow, (Entity)(entity1 != null ? entity1 : arrow));
        if (arrow.getWeaponItem() != null && (level = arrow.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)arrow.getWeaponItem(), (Entity)target, (DamageSource)damagesource, (float)((float)d0));
        }
        int j = Mth.ceil((double)Mth.clamp((double)((double)f * d0), (double)0.0, (double)2.147483647E9));
        if (arrow.isCritArrow()) {
            long k = arrow.getRandom().nextInt(j / 2 + 2);
            j = (int)Math.min(k + (long)j, Integer.MAX_VALUE);
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(target);
        }
        boolean bl = flag = target.getType() == EntityType.ENDERMAN;
        if (arrow.isOnFire() && !flag) {
            target.igniteForSeconds(5.0f);
        }
        target.hurt(damagesource, (float)j);
    }

    public boolean isReturning(Entity projectile) {
        return projectile.getPersistentData().getBoolean("alchemancy:loyal_returning");
    }

    public boolean canTriggerImpactEffects(Projectile projectile, HitResult hitResult) {
        return hitResult.getType() != HitResult.Type.ENTITY || !this.isReturning((Entity)projectile);
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (this.isReturning((Entity)projectile)) {
            if (rayTraceResult.getType() == HitResult.Type.ENTITY && rayTraceResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
                if (entityHitResult.getEntity() == projectile.getOwner()) {
                    ItemEntity droppedItem = new ItemEntity(projectile.level(), projectile.position().x, projectile.position().y, projectile.position().z, stack.copy());
                    droppedItem.setNoPickUpDelay();
                    projectile.level().addFreshEntity((Entity)droppedItem);
                    projectile.discard();
                }
                event.setCanceled(true);
            }
        } else {
            if (rayTraceResult.getType() == HitResult.Type.ENTITY && rayTraceResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
                Entity entity = entityHitResult.getEntity();
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)projectile;
                    this.dealArrowDamage(arrow, entity);
                } else {
                    DamageSource damageSource = projectile.damageSources().thrown((Entity)projectile, projectile.getOwner());
                    entity.hurt(damageSource, (float)(Property.getItemAttackDamage(stack) - 1.0));
                }
            }
            projectile.getPersistentData().putBoolean("alchemancy:loyal_returning", true);
            event.setCanceled(true);
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale(-1.0));
        }
    }

    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity entity) {
        Entity owner;
        Level level;
        if (entity.level().isClientSide() || !((level = entity.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        UUID ownerUuid = (UUID)this.getData(stack);
        Entity entity2 = owner = ownerUuid == null ? null : serverLevel.getEntity(ownerUuid);
        if (!entity.hasPickUpDelay() && owner != null && owner.distanceTo((Entity)entity) < 50.0f) {
            entity.setDeltaMovement(owner.position().subtract(entity.position()).normalize().scale(0.25));
            entity.hasImpulse = true;
        }
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        this.setData(stack, user.getUUID());
    }

    @Override
    public int getColor(ItemStack stack) {
        return 6735023;
    }

    @Override
    public UUID readData(CompoundTag tag) {
        return tag.getUUID("owner");
    }

    @Override
    public CompoundTag writeData(final UUID data) {
        return new CompoundTag(this){
            {
                this.putUUID("owner", data);
            }
        };
    }

    @Override
    public UUID getDefaultData() {
        return null;
    }

    @Override
    public int getPriority() {
        return 100;
    }
}

