/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.client.particle.options.SparkParticleOptions;
import net.cibernet.alchemancy.events.handler.PropertyEventHandler;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.mixin.accessors.AbstractArrowAccessor;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.ColorUtils;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class MagneticProperty
extends Property {
    private static final float RADIUS = 20.0f;
    private static final float ARMOR_RANGE = 0.25f;
    public static final ParticleOptions PARTICLE_A = new SparkParticleOptions(Vec3.fromRGB24((int)0xFF8484).toVector3f(), 0.65f);
    public static final ParticleOptions PARTICLE_B = new SparkParticleOptions(Vec3.fromRGB24((int)0x8484FF).toVector3f(), 0.65f);

    @Override
    public void modifyKnockBackReceived(LivingEntity user, ItemStack stack, EquipmentSlot slot, LivingKnockBackEvent event) {
        if (slot == EquipmentSlot.FEET && user.level().getBlockState(user.getBlockPosBelowThatAffectsMyMovement()).is(AlchemancyTags.Blocks.MAGNETIC_STICKS_TO)) {
            event.setCanceled(true);
        }
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        block3: {
            Level level;
            Vec3 delta;
            block4: {
                block2: {
                    delta = user.getDeltaMovement();
                    level = user.level();
                    if (slot != EquipmentSlot.HEAD) break block2;
                    Vec3 hitStart = new Vec3(user.getX(), user.getY(1.0), user.getZ());
                    BlockHitResult hit = user.level().clip(new ClipContext(hitStart, hitStart.add(0.0, 0.25, 0.0), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)user));
                    if (!level.getBlockState(hit.getBlockPos()).is(AlchemancyTags.Blocks.MAGNETIC_STICKS_TO)) break block3;
                    user.setDeltaMovement(delta.x, Math.max(delta.y, 0.0), delta.z);
                    user.resetFallDistance();
                    user.setOnGround(true);
                    MagneticProperty.playParticles(user, user.getY(1.0), stack);
                    break block3;
                }
                if (slot != EquipmentSlot.FEET) break block4;
                if (!user.level().getBlockState(user.getBlockPosBelowThatAffectsMyMovement()).is(AlchemancyTags.Blocks.MAGNETIC_STICKS_TO)) break block3;
                MagneticProperty.playParticles(user, user.getY((double)0.1f), stack);
                user.setDeltaMovement(delta.x, Math.min(delta.y, (double)0.2f), delta.z);
                break block3;
            }
            if (slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS) {
                double y = user.getY(0.5 + (slot == EquipmentSlot.CHEST ? 0.2 : -0.2));
                double hitOffset = (double)user.getBbWidth() * 0.5 + 0.25;
                Vec3 hitStart = new Vec3(user.getX(), y, user.getZ());
                for (Direction direction : Direction.values()) {
                    BlockHitResult hit;
                    if (!direction.getAxis().isHorizontal() || !level.getBlockState((hit = user.level().clip(new ClipContext(hitStart, hitStart.add((double)direction.getStepX() * hitOffset, 0.0, (double)direction.getStepZ() * hitOffset), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)user))).getBlockPos()).is(AlchemancyTags.Blocks.MAGNETIC_STICKS_TO)) continue;
                    user.setDeltaMovement(delta.x, Math.max(delta.y, 0.0), delta.z);
                    user.resetFallDistance();
                    user.setOnGround(true);
                    MagneticProperty.playParticles(user, y, stack);
                    break;
                }
            }
        }
        MagneticProperty.repelUser((Entity)user);
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        MagneticProperty.repelUser((Entity)projectile);
    }

    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity itemEntity) {
        MagneticProperty.repelUser((Entity)itemEntity);
    }

    public static void playParticles(LivingEntity user, double y, ItemStack stack) {
        MagneticProperty.playParticles((Entity)user, y, stack, 4);
    }

    public static void playParticles(Entity user, double y, ItemStack stack, int amount) {
        Level level = user.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(SparklingProperty.getParticles(stack).orElse((ParticleOptions)ParticleTypes.ELECTRIC_SPARK), user.getX(), y, user.getZ(), amount, (double)(user.getBbWidth() * 0.45f), 0.0, (double)(user.getBbWidth() * 0.45f), 0.0);
        }
    }

    @Override
    public void onItemUseTick(LivingEntity user, ItemStack stack, LivingEntityUseItemEvent.Tick event) {
        MagneticProperty.magnetize(user.level(), (Entity)user, user.getEyePosition(), stack);
        Level level = user.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(SparklingProperty.getParticles(stack).orElse(PARTICLE_A), user.getX(), user.getY(0.5), user.getZ(), 1, (double)(user.getBbWidth() * 0.5f), (double)(user.getBbHeight() * 0.25f), (double)(user.getBbWidth() * 0.5f), 0.0);
            serverLevel.sendParticles(SparklingProperty.getParticles(stack).orElse(PARTICLE_B), user.getX(), user.getY(0.5), user.getZ(), 1, (double)(user.getBbWidth() * 0.5f), (double)(user.getBbHeight() * 0.25f), (double)(user.getBbWidth() * 0.5f), 0.0);
        }
    }

    @Override
    public void onRootedTick(RootedItemBlockEntity root, List<LivingEntity> entitiesInBounds) {
        MagneticProperty.magnetize(root.getLevel(), null, root.getBlockPos().getCenter(), root.getItem());
    }

    @Override
    public void onRootedAnimateTick(RootedItemBlockEntity root, RandomSource randomSource) {
        MagneticProperty.playRootedParticles(root, randomSource, PARTICLE_A);
        MagneticProperty.playRootedParticles(root, randomSource, PARTICLE_B);
    }

    private static <E extends Entity> void repelUser(Entity user, Class<E> targetEntities, float strength, Predicate<E> predicate) {
        Level level;
        float radius = 5.0f;
        int count = 0;
        for (Entity target : user.level().getEntitiesOfClass(targetEntities, CommonUtils.boundingBoxAroundPoint(user.position(), radius), predicate)) {
            if (target.equals((Object)user)) continue;
            double distanceTo = target.position().distanceTo(user.position());
            float str = (float)Math.max(0.0, (double)radius - distanceTo) * 0.05f * strength;
            user.hasImpulse = true;
            Vec3 vec3 = user.getDeltaMovement();
            Vec3 vec31 = target.position().subtract(user.position()).normalize().scale((double)str);
            user.setDeltaMovement(vec3.subtract(vec31));
            Level level2 = target.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                serverLevel.sendParticles(PARTICLE_B, target.getX(), target.getY(0.5), target.getZ(), 1, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.25f), (double)(target.getBbWidth() * 0.25f), 0.0);
            }
            ++count;
        }
        if (count > 0 && (level = user.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(PARTICLE_B, user.getX(), user.getY(0.5), user.getZ(), count, (double)(user.getBbWidth() * 0.5f), (double)(user.getBbHeight() * 0.25f), (double)(user.getBbWidth() * 0.25f), 0.0);
        }
    }

    public static void magnetize(Level level, @Nullable Entity user, Vec3 center, ItemStack stack) {
        if (level.isClientSide()) {
            return;
        }
        MagneticProperty.forEachInRadius(user, level, center, LivingEntity.class, entity -> true, target -> {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stackInSlot = target.getItemBySlot(slot);
                if (!MagneticProperty.canBeMagnetized(stackInSlot)) continue;
                if (!(target instanceof Player)) {
                    target.move(MoverType.PLAYER, center.subtract(target.position()).normalize().scale((double)0.05f));
                }
                MagneticProperty.playParticles((Entity)target, target.getRandomY(), stack, 1);
                if (!(level.getRandom().nextFloat() < 0.005f)) continue;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    player.drop(stackInSlot, true);
                } else {
                    HollowProperty.nonPlayerDrop((Entity)target, stackInSlot, false, true);
                }
                target.setItemSlot(slot, ItemStack.EMPTY);
            }
        });
        MagneticProperty.pullEntities(user, stack, level, center, ItemEntity.class, itemEntity -> MagneticProperty.canBeMagnetized(itemEntity.getItem()), ItemEntity::setNoPickUpDelay);
        MagneticProperty.pullEntities(user, stack, level, center, AbstractArrow.class, arrow -> MagneticProperty.canBeMagnetized(arrow.getPickupItemStackOrigin()), arrow -> {
            if (!level.isClientSide() && arrow.pickup == AbstractArrow.Pickup.ALLOWED && user instanceof Player) {
                Player player = (Player)user;
                ((AbstractArrowAccessor)arrow).setInGround(true);
                arrow.playerTouch(player);
            }
        });
        MagneticProperty.pullEntities(user, stack, level, center, Projectile.class, entity -> {
            ItemSupplier supplier;
            return entity instanceof ItemSupplier && MagneticProperty.canBeMagnetized((supplier = (ItemSupplier)entity).getItem());
        }, projectile -> {
            ItemEntity droppedItem = new ItemEntity(projectile.level(), projectile.position().x, projectile.position().y, projectile.position().z, stack.copy());
            droppedItem.setNoPickUpDelay();
            projectile.level().addFreshEntity((Entity)droppedItem);
            projectile.discard();
        });
        MagneticProperty.pullEntities(user, stack, level, center, LivingEntity.class, entity -> entity.getType().is(AlchemancyTags.EntityTypes.PULLED_IN_BY_MAGNETIC), e -> {}, 0.075f);
    }

    public static void repelUser(Entity user) {
        MagneticProperty.repelUser(user, LivingEntity.class, 0.5f, target -> {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!InfusedPropertiesHelper.hasProperty(target.getItemBySlot(slot), AlchemancyProperties.MAGNETIC)) continue;
                return true;
            }
            return false;
        });
        MagneticProperty.repelUser(user, Projectile.class, 0.25f, target -> InfusedPropertiesHelper.hasProperty(PropertyEventHandler.getProjectileItemStack(target), AlchemancyProperties.MAGNETIC));
    }

    private static <E extends Entity> int forEachInRadius(@Nullable Entity user, Level level, Vec3 center, Class<E> targetClass, Predicate<E> targetCondition, Consumer<E> consumer) {
        int count = 0;
        for (Entity target : level.getEntitiesOfClass(targetClass, CommonUtils.boundingBoxAroundPoint(center, 20.0f), targetCondition)) {
            if (target == user) continue;
            consumer.accept(target);
            ++count;
        }
        return count;
    }

    private static <E extends Entity> int pullEntities(@Nullable Entity user, ItemStack stack, Level level, Vec3 center, Class<E> targetClass, Predicate<E> targetCondition, Consumer<E> whenCloseEnough) {
        return MagneticProperty.pullEntities(user, stack, level, center, targetClass, targetCondition, whenCloseEnough, 1.0f);
    }

    private static <E extends Entity> int pullEntities(@Nullable Entity user, ItemStack stack, Level level, Vec3 center, Class<E> targetClass, Predicate<E> targetCondition, Consumer<E> whenCloseEnough, float strength) {
        return MagneticProperty.forEachInRadius(user, level, center, targetClass, targetCondition, target -> {
            double distanceTo = target.position().distanceTo(center);
            double d = user == null ? 0.5 : (double)user.getBbWidth() * 0.5 + 1.0;
            if (distanceTo < d) {
                whenCloseEnough.accept(target);
            }
            float str = (float)Math.max(0.0, 20.0 - distanceTo) * 0.05f * strength;
            if (target instanceof AbstractArrowAccessor) {
                AbstractArrowAccessor arrow = (AbstractArrowAccessor)target;
                arrow.setInGround(false);
            }
            Vec3 vec3 = target.getDeltaMovement();
            Vec3 vec31 = target.position().subtract(center).normalize().scale((double)str);
            target.setDeltaMovement(vec3.scale(1.0 - 0.5 * (1.0 - distanceTo / 20.0)).subtract(vec31));
            MagneticProperty.playParticles(target, target.getRandomY(), stack, 1);
            target.hasImpulse = true;
            target.hurtMarked = true;
        });
    }

    public static boolean canBeMagnetized(ItemStack stack) {
        return InfusedPropertiesHelper.hasProperty(stack, AlchemancyTags.Properties.AFFECTED_BY_MAGNETIC) || AlchemancyProperties.getDormantProperties(stack).stream().anyMatch(p -> p.is(AlchemancyTags.Properties.AFFECTED_BY_MAGNETIC));
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        return this.getName(stack);
    }

    @Override
    public Component getName(ItemStack stack) {
        return Component.translatable((String)(this.getLanguageKey() + ".format"), (Object[])new Object[]{Component.translatable((String)(this.getLanguageKey() + ".a")).withColor(0xFF0000), Component.translatable((String)(this.getLanguageKey() + ".b")).withColor(255)});
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        event.getEntity().startUsingItem(event.getHand());
        event.setCancellationResult(InteractionResult.CONSUME);
        event.setCanceled(true);
    }

    @Override
    public int modifyUseDuration(ItemStack stack, int original, int result) {
        return 72000;
    }

    @Override
    public Optional<UseAnim> modifyUseAnimation(ItemStack stack, UseAnim original, Optional<UseAnim> current) {
        return Optional.of(UseAnim.BOW);
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.flashColorsOverTime(1000.0, 0xFF0000, 255);
    }
}

