/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.properties.special.ClayMoldProperty;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MalleableProperty
extends Property {
    @Override
    public void onEntityItemDestroyed(ItemStack stack, Entity itemEntity, DamageSource damageSource) {
        if (stack.isDamageableItem()) {
            stack.setDamageValue(stack.getMaxDamage() - 1);
        }
        itemEntity.level().addFreshEntity((Entity)new ItemEntity(itemEntity.level(), itemEntity.position().x, itemEntity.position().y, itemEntity.position().z, this.getUnshapedClay(stack)));
        stack.setCount(0);
    }

    @Override
    public int modifyDurabilityConsumed(ItemStack stack, ServerLevel level, @Nullable LivingEntity user, int originalAmount, int resultingAmount, RandomSource random) {
        if (user != null && stack.getMaxDamage() <= stack.getDamageValue() + resultingAmount) {
            stack.setDamageValue(stack.getMaxDamage() - 1);
            ItemStack clay = this.getUnshapedClay(stack);
            if (user.getMainHandItem() == stack) {
                user.setItemInHand(InteractionHand.MAIN_HAND, clay);
            } else if (user.getOffhandItem() == stack) {
                user.setItemInHand(InteractionHand.OFF_HAND, clay);
            } else if (user instanceof Player) {
                Player player = (Player)user;
                if (!player.addItem(clay)) {
                    player.drop(clay, true);
                }
            } else {
                HollowProperty.nonPlayerDrop((Entity)user, clay, false, true);
            }
        }
        return resultingAmount;
    }

    public ItemStack getUnshapedClay(ItemStack stackToStore) {
        ItemStack clay = AlchemancyItems.UNSHAPED_CLAY.toStack();
        ((ClayMoldProperty)AlchemancyProperties.CLAY_MOLD.get()).setData(clay, stackToStore.copy());
        InfusedPropertiesHelper.forEachProperty(stackToStore, propertyHolder -> {
            if (propertyHolder.is(AlchemancyTags.Properties.RETAINED_BY_UNSHAPED_CLAY)) {
                InfusedPropertiesHelper.addProperty(clay, (Holder<Property>)propertyHolder);
                Object patt0$temp = propertyHolder.value();
                if (patt0$temp instanceof IDataHolder) {
                    IDataHolder dataHolder = (IDataHolder)patt0$temp;
                    dataHolder.copyData(stackToStore, clay);
                }
            }
        });
        return clay;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 11516374;
    }
}

