/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class NonlethalProperty
extends Property {
    @Override
    public void onIncomingAttack(Entity user, ItemStack weapon, LivingEntity target, LivingIncomingDamageEvent event) {
        event.setCanceled(true);
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        Entity entity;
        if (rayTraceResult.getType() == HitResult.Type.ENTITY && rayTraceResult instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)rayTraceResult).getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            InfusedPropertiesHelper.forEachProperty(stack, propertyHolder -> ((Property)propertyHolder.value()).onAttack((Entity)projectile, stack, NonlethalProperty.activationDamageSource(projectile.level(), (Entity)projectile, projectile.position()), target));
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 0xFFFFFF;
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

