/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PhotosyntheticProperty
extends Property {
    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (PhotosyntheticProperty.canRepair(stack) && user.tickCount % 600 == 0 && PhotosyntheticProperty.canPhotosynthesize(level, user.blockPosition())) {
            PhotosyntheticProperty.repairItem(stack, 1);
        }
    }

    @Override
    public void onRootedTick(RootedItemBlockEntity root, List<LivingEntity> entitiesInBounds) {
        Level level = root.getLevel();
        ItemStack stack = root.getItem();
        if (PhotosyntheticProperty.canRepair(stack) && root.getTickCount() % 300 == 0 && PhotosyntheticProperty.canPhotosynthesize(level, root.getBlockPos())) {
            PhotosyntheticProperty.repairItem(stack, 1);
        }
    }

    @Override
    public void onRootedAnimateTick(RootedItemBlockEntity root, RandomSource random) {
        BlockPos pPos = root.getBlockPos();
        Level level = root.getLevel();
        if (root.getItem().isDamaged() && PhotosyntheticProperty.canPhotosynthesize(level, pPos)) {
            PhotosyntheticProperty.playRootedParticles(root, random, (ParticleOptions)ParticleTypes.WAX_ON);
        }
    }

    public static boolean canPhotosynthesize(Level level, BlockPos pos) {
        return level.canSeeSky(pos) && level.isDay();
    }

    @Override
    public int getColor(ItemStack stack) {
        return 4373526;
    }
}

