/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesComponent;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

public class ResizedProperty
extends Property
implements IDataHolder<Float> {
    private static final ResourceLocation MODIFIER_KEY = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"resized_modifier");
    public static final float MIN = 0.5f;
    public static final float MAX = 2.0f;

    @Override
    public void applyAttributes(ItemAttributeModifierEvent event) {
        float size = ((Float)this.getData(event.getItemStack())).floatValue();
        event.addModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(MODIFIER_KEY, (double)(size - 1.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND);
        event.addModifier(Attributes.ATTACK_SPEED, new AttributeModifier(MODIFIER_KEY, (double)(1.0f / size - 1.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND);
    }

    @Override
    public boolean cluelessCanReset() {
        return false;
    }

    @Override
    public boolean onInfusedByDormantProperty(ItemStack stack, ItemStack propertySource, ForgeRecipeGrid grid, List<Holder<Property>> propertiesToAdd, boolean consumeItem) {
        float newSize;
        float currentSize = ((Float)this.getData(stack)).floatValue();
        if (!((Float)this.getData(propertySource)).equals(this.getDefaultData())) {
            newSize = ((Float)this.getData(propertySource)).floatValue();
        } else if (propertySource.is(AlchemancyTags.Items.INCREASES_RESIZED) && currentSize < 2.0f) {
            newSize = Math.min(2.0f, currentSize + 0.1f);
        } else if (propertySource.is(AlchemancyTags.Items.DECREASES_RESIZED) && currentSize > 0.5f) {
            newSize = Math.max(0.5f, currentSize - 0.1f);
        } else {
            return false;
        }
        if (newSize == this.getDefaultData().floatValue()) {
            propertiesToAdd.remove(this.asHolder());
            if (consumeItem) {
                InfusedPropertiesHelper.removeProperty(stack, this.asHolder());
            }
        } else if (consumeItem) {
            this.setData(stack, Float.valueOf(newSize));
        }
        return true;
    }

    @Override
    public Float readData(CompoundTag tag) {
        return Float.valueOf(tag.getFloat("size"));
    }

    @Override
    public CompoundTag writeData(final Float data) {
        return new CompoundTag(this){
            {
                this.putFloat("size", data.floatValue());
            }
        };
    }

    @Override
    public Float combineData(@Nullable Float currentData, Float newData) {
        return Float.valueOf(currentData == null ? newData.floatValue() : Math.clamp(currentData.floatValue() + newData.floatValue(), 0.5f, 2.0f));
    }

    @Override
    public Float getDefaultData() {
        return Float.valueOf(1.0f);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 14551807;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        return Component.translatable((String)"property.detail", (Object[])new Object[]{super.getDisplayText(stack), Component.translatable((String)"property.detail.percentage", (Object[])new Object[]{Math.round(((Float)this.getData(stack)).floatValue() * 100.0f)})}).withColor(this.getColor(stack));
    }

    @Override
    public Component getName(ItemStack stack) {
        if (stack.is(AlchemancyTags.Items.INCREASES_RESIZED)) {
            return Component.translatable((String)"property.alchemancy.resized.increase").withColor(this.getColor(stack));
        }
        if (stack.is(AlchemancyTags.Items.DECREASES_RESIZED)) {
            return Component.translatable((String)"property.alchemancy.resized.decrease").withColor(this.getColor(stack));
        }
        if (!((Float)this.getData(stack)).equals(this.getDefaultData())) {
            return this.getDisplayText(stack);
        }
        return super.getName(stack);
    }

    @Override
    public Collection<ItemStack> populateCreativeTab(DeferredItem<Item> capsuleItem, Holder<Property> holder) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (float size = 0.5f; size <= 2.0f; size += 1.5f) {
            ItemStack stack = capsuleItem.toStack();
            stack.set(AlchemancyItems.Components.STORED_PROPERTIES, (Object)new InfusedPropertiesComponent(List.of(holder)));
            this.setData(stack, Float.valueOf(size));
            result.add(stack);
        }
        return result;
    }
}

