/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.entity.InfusedItemProjectile;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class ScattershotProperty
extends HollowProperty {
    public static final float THROW_VELOCITY = 1.5f;
    public static final int THROW_AMOUNT = 8;

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled()) {
            this.throwItem(event.getLevel(), (LivingEntity)event.getEntity(), event.getItemStack(), 8);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public void onPickUpAnyItem(Player user, ItemStack stack, EquipmentSlot slot, ItemEntity itemToPickUp, boolean canPickUp, ItemEntityPickupEvent.Pre event) {
    }

    @Override
    @Nullable
    public ItemInteractionResult onRootedRightClick(RootedItemBlockEntity root, Player user, InteractionHand hand, BlockHitResult hitResult) {
        return null;
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        if (currentResult != InfusionPropertyDispenseBehavior.DispenseResult.PASS) {
            return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
        }
        ItemStack storedItem = (ItemStack)this.getData(stack);
        if (storedItem.isEmpty()) {
            return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
        }
        ItemStack originalStack = stack;
        stack = storedItem.split(8);
        this.setData(originalStack, storedItem);
        stack = stack.copy();
        stack.setCount(1);
        this.throwItem(stack, blockSource, direction);
        return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
    }

    private void throwItem(ItemStack stack, BlockSource blockSource, Direction direction) {
        Position position = ProjectileItem.DispenseConfig.DEFAULT.positionFunction().getDispensePosition(blockSource, direction);
        float throwInaccuracy = this.getThrowInaccuracy(stack);
        this.throwItem((Level)blockSource.level(), stack, position.x(), position.y(), position.z(), direction.getStepX(), direction.getStepY(), direction.getStepZ(), ProjectileItem.DispenseConfig.DEFAULT.power() * (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SHARPSHOOTING) ? 1.5f : 1.0f), ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * throwInaccuracy, 8);
        InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
    }

    private void throwItem(Level level, ItemStack stack, double x, double y, double z, double xScale, double yScale, double zScale, float power, float inaccuracy, int amount) {
        for (int i = 0; i < amount && !stack.isEmpty(); ++i) {
            Object projectile;
            Item item = stack.getItem();
            if (item instanceof ProjectileItem) {
                ProjectileItem projectileItem = (ProjectileItem)item;
                projectile = projectileItem.asProjectile(level, (Position)new Vec3(x, y, z), stack, Direction.UP);
            } else {
                InfusedItemProjectile itemProjectile = new InfusedItemProjectile(x, y, z, level);
                itemProjectile.setItem(stack.split(1));
                projectile = itemProjectile;
            }
            projectile.shoot(xScale, yScale, zScale, power, inaccuracy);
            level.addFreshEntity((Entity)projectile);
        }
    }

    private void throwItem(Level level, LivingEntity user, ItemStack stack, int amount) {
        if (stack.isEmpty()) {
            return;
        }
        ItemStack storedItem = (ItemStack)this.getData(stack);
        if (storedItem.isEmpty()) {
            user.playSound(SoundEvents.DISPENSER_FAIL);
            return;
        }
        ItemStack originalStack = stack;
        stack = storedItem.split(8);
        this.setData(originalStack, storedItem);
        level.playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)AlchemancySoundEvents.THROWABLE.value(), SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            boolean sharpshooting = InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SHARPSHOOTING);
            float throwInaccuracy = this.getThrowInaccuracy(stack);
            for (int i = 0; i < amount && !stack.isEmpty(); ++i) {
                InfusedItemProjectile projectile;
                Item item = stack.getItem();
                if (item instanceof ProjectileItem) {
                    ProjectileItem projectileItem = (ProjectileItem)item;
                    projectile = projectileItem.asProjectile(level, (Position)new Vec3(user.getX(), user.getEyeY() - (double)0.1f, user.getZ()), stack, Direction.UP);
                } else {
                    InfusedItemProjectile itemProjectile = new InfusedItemProjectile(user, level);
                    itemProjectile.setItem(stack.split(1));
                    projectile = itemProjectile;
                }
                projectile.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f * (sharpshooting ? 1.5f : 1.0f), throwInaccuracy);
                level.addFreshEntity((Entity)projectile);
            }
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        }
        stack.consume(1, user);
    }

    private float getThrowInaccuracy(ItemStack stack) {
        return stack.getCount();
    }

    @Override
    public int getColor(ItemStack stack) {
        return 13383168;
    }
}

