/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import net.cibernet.alchemancy.blocks.SculkBudBlock;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.blocks.blockentities.SculkBudBlockEntity;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyBlocks;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class SculkingProperty
extends Property {
    @Override
    public void onKill(LivingEntity target, LivingEntity user, ItemStack stack, LivingDeathEvent event) {
        if (user.level().isClientSide()) {
            return;
        }
        SculkingProperty.createSculkBud(target, event.getSource());
    }

    @Override
    public void onRootedTick(RootedItemBlockEntity root, List<LivingEntity> entitiesInBounds) {
        for (LivingEntity target : root.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(root.getBlockPos()).inflate(8.0), living -> living.isDeadOrDying() && !living.wasExperienceConsumed())) {
            SculkingProperty.createSculkBud(target, target.getLastDamageSource());
        }
    }

    @Override
    public void onRootedAnimateTick(RootedItemBlockEntity root, RandomSource randomSource) {
        SculkingProperty.playRootedParticles(root, randomSource, (ParticleOptions)ParticleTypes.SCULK_CHARGE_POP);
    }

    public static void createSculkBud(LivingEntity target, DamageSource damageSource) {
        int charge;
        ServerLevel level = (ServerLevel)target.level();
        BlockPos pos = target.blockPosition();
        BlockState state = level.getBlockState(pos);
        BlockState sculk = ((SculkBudBlock)((Object)AlchemancyBlocks.SCULK_BUD.get())).defaultBlockState();
        if (sculk.canSurvive((LevelReader)level, pos) && (state.isAir() || state.canBeReplaced()) && level.getBlockState(pos.below()).is(BlockTags.SCULK_REPLACEABLE) && (charge = target.getExperienceReward(level, (Entity)Optionull.map((Object)damageSource, DamageSource::getEntity))) > 0) {
            level.setBlock(pos, sculk, 11);
            SculkBudBlockEntity blockEntity = (SculkBudBlockEntity)level.getBlockEntity(pos);
            blockEntity.addCursor(charge, pos);
            target.skipDropExperience();
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(4.0f, 37525, 213328);
    }
}

