/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import java.util.function.Consumer;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.properties.BrittleProperty;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SensitiveProperty
extends Property {
    public static <E extends Entity> boolean sense(Level level, Class<E> classSelector, AABB bounds, List<E> ignore, Consumer<E> action) {
        List entitiesInBounds = level.getEntitiesOfClass(classSelector, bounds);
        entitiesInBounds.removeAll(ignore);
        for (Entity target : entitiesInBounds) {
            action.accept(target);
        }
        return !entitiesInBounds.isEmpty();
    }

    public static <E extends Entity> boolean senseAndActivateOnTargets(Level level, BlockPos pos, ItemStack stack, Class<E> classSelector, E ... ignore) {
        return SensitiveProperty.sense(level, classSelector, new AABB(pos), List.of(ignore), entity -> SensitiveProperty.activateByBlock(level, pos, entity, stack));
    }

    public static <E extends Entity> boolean senseAndActivateOnTargets(Entity source, ItemStack stack, float radius, Class<E> classSelector, E ... ignore) {
        return SensitiveProperty.sense(source.level(), classSelector, source.getBoundingBox().inflate((double)radius), List.of(ignore), entity -> SensitiveProperty.activateByEntity(source, entity, stack));
    }

    public static <E extends Entity> boolean senseAndActivateOnSelf(Entity source, ItemStack stack, float radius, Class<E> classSelector, E ... ignore) {
        if (SensitiveProperty.sense(source.level(), classSelector, source.getBoundingBox().inflate((double)radius), List.of(ignore), entity -> {})) {
            SensitiveProperty.activateByEntity(source, source, stack);
            return true;
        }
        return false;
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        Player player;
        ItemCooldowns cooldowns;
        if (user instanceof Player && !(cooldowns = (player = (Player)user).getCooldowns()).isOnCooldown(stack.getItem()) && SensitiveProperty.senseAndActivateOnSelf((Entity)user, (ItemStack)stack, (float)1.0f, LivingEntity.class, (Entity[])new LivingEntity[]{user})) {
            player.level().playSound(player, (Entity)player, SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 0.5f, 0.6f);
            cooldowns.addCooldown(stack.getItem(), 100);
        }
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        LivingEntity owner;
        LivingEntity[] livingEntityArray = new LivingEntity[1];
        Entity entity = projectile.getOwner();
        LivingEntity livingEntity = livingEntityArray[0] = entity instanceof LivingEntity ? (owner = (LivingEntity)entity) : null;
        if (SensitiveProperty.senseAndActivateOnSelf((Entity)projectile, (ItemStack)stack, (float)1.0f, LivingEntity.class, (Entity[])livingEntityArray)) {
            projectile.level().playSound(null, projectile.position().x, projectile.position().y, projectile.position().z, SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 0.5f, 0.6f);
            BrittleProperty.breakProjectile(stack, projectile);
        }
    }

    @Override
    public void onRootedTick(RootedItemBlockEntity root, List<LivingEntity> livingEntities) {
        if (root.getTickCount() % 20 == 0 && SensitiveProperty.senseAndActivateOnTargets((Level)root.getLevel(), (BlockPos)root.getBlockPos(), (ItemStack)root.getItem(), Entity.class, (Entity[])new Entity[0])) {
            root.getLevel().playSound(null, root.getBlockPos(), SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 0.5f, 0.6f);
        }
    }

    @Override
    public void onRootedAnimateTick(RootedItemBlockEntity root, RandomSource random) {
        if (root.getTickCount() % 20 == 0) {
            SensitiveProperty.playRootedParticles(root, random, (ParticleOptions)DustColorTransitionOptions.SCULK_TO_REDSTONE);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 14850052;
    }
}

