/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShatteringProperty
extends Property
implements IDataHolder<Boolean> {
    private static final float RADIUS = 3.0f;

    @Override
    public int modifyDurabilityConsumed(ItemStack stack, ServerLevel level, @Nullable LivingEntity user, int originalAmount, int resultingAmount, RandomSource random) {
        if (user != null && stack.getMaxDamage() <= stack.getDamageValue() + resultingAmount) {
            this.shatter((Level)level, (Entity)user, stack);
        }
        return resultingAmount;
    }

    @Override
    public void onEntityItemDestroyed(ItemStack stack, Entity itemEntity, DamageSource cause) {
        if (!itemEntity.isRemoved()) {
            Level level = itemEntity.level();
            this.shatter(level, itemEntity, stack);
            itemEntity.discard();
        }
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (((Boolean)this.getData(stack)).booleanValue()) {
            this.setData(stack, Boolean.valueOf(false));
        }
    }

    public void shatter(Level level, Entity source, ItemStack stack) {
        if (((Boolean)this.getData(stack)).booleanValue()) {
            return;
        }
        this.setData(stack, Boolean.valueOf(true));
        RandomSource rand = level.getRandom();
        List entities = level.getEntitiesOfClass(LivingEntity.class, source.getBoundingBox().inflate(3.0));
        DamageSource damageSource = ShatteringProperty.activationDamageSource(level, source, source.position());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 20; ++i) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, source.position().x, source.position().y, source.position().z, 1, 0.0, 0.0, 0.0, rand.nextDouble() * 0.5);
            }
        }
        InfusedPropertiesHelper.forEachProperty(stack, propertyHolder -> {
            ShatteringProperty.activateByEntity(source, source, stack);
            for (LivingEntity target : entities) {
                if (!(target.distanceTo(source) <= 3.0f)) continue;
                ((Property)propertyHolder.value()).onAttack(source, stack, damageSource, target);
            }
        });
        this.setData(stack, Boolean.valueOf(false));
    }

    @Override
    public int getColor(ItemStack stack) {
        return 5482165;
    }

    @Override
    public Boolean readData(CompoundTag tag) {
        return tag.getBoolean("activated");
    }

    @Override
    public CompoundTag writeData(final Boolean data) {
        return new CompoundTag(this){
            {
                this.putBoolean("activated", data);
            }
        };
    }

    @Override
    public Boolean getDefaultData() {
        return false;
    }
}

