/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class SlipperyProperty
extends Property {
    @Override
    public void onAttack(@Nullable Entity user, ItemStack weapon, DamageSource damageSource, LivingEntity target) {
        if (user instanceof Player) {
            Player player = (Player)user;
            player.drop(weapon.copy(), true);
            weapon.setCount(0);
        } else if (user instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)user;
            HollowProperty.nonPlayerDrop(user, weapon.copy(), false, true);
            weapon.setCount(0);
        }
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        event.getEntity().drop(event.getItemStack(), true);
        event.getEntity().setItemInHand(event.getHand(), ItemStack.EMPTY);
        event.setCancellationResult(InteractionResult.FAIL);
        event.setCanceled(true);
    }

    @Override
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        event.getEntity().drop(event.getItemStack(), true);
        event.getEntity().setItemInHand(event.getHand(), ItemStack.EMPTY);
    }

    @Override
    public void onFall(LivingEntity entity, ItemStack stack, EquipmentSlot slot, LivingFallEvent event) {
        BlockState state;
        if (slot == EquipmentSlot.FEET && (state = entity.getBlockStateOn()).getBlock() instanceof StairBlock) {
            Vec3i dir = ((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)StairBlock.FACING)).getOpposite().getNormal();
            Vec3 delta = entity.getDeltaMovement();
            entity.setDeltaMovement(delta.add(new Vec3((double)dir.getX(), (double)dir.getY(), (double)dir.getZ()).scale((double)0.7f)));
        }
    }

    @Override
    public float modifyStepOnFriction(Entity user, ItemStack stack, float originalResult, float result) {
        return Math.min(result + 0.38f, Math.max(result, 0.999998f));
    }

    @Override
    public int getColor(ItemStack stack) {
        return 12974578;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        return super.getDisplayText(stack).copy().withStyle(ChatFormatting.ITALIC);
    }
}

