/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Random;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class SparkingProperty
extends Property {
    private static final Random random = new Random();
    private static float sparkColor = 0.0f;

    @Override
    public void onDamageReceived(LivingEntity user, ItemStack weapon, EquipmentSlot slot, DamageSource damageSource) {
        if (damageSource.is(Tags.DamageTypes.IS_PHYSICAL)) {
            SparkingProperty.ignite(user.level(), user.blockPosition(), Direction.DOWN);
        }
    }

    @Override
    public void onFall(LivingEntity entity, ItemStack stack, EquipmentSlot slot, LivingFallEvent event) {
        if ((slot == EquipmentSlot.FEET || slot == EquipmentSlot.BODY) && event.getDistance() > 3.0f) {
            SparkingProperty.ignite(entity.level(), entity.blockPosition(), Direction.DOWN);
        }
    }

    @Override
    public void onActivation(Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        if (source == null) {
            source = target;
        }
        SparkingProperty.ignite(source.level(), source.blockPosition(), Direction.DOWN);
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (rayTraceResult.getType() == HitResult.Type.BLOCK && rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            SparkingProperty.ignite(projectile.level(), blockHitResult.getBlockPos().relative(blockHitResult.getDirection()), blockHitResult.getDirection());
        } else if (rayTraceResult.getType() == HitResult.Type.ENTITY && rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            SparkingProperty.ignite(projectile.level(), entityHitResult.getEntity().blockPosition(), Direction.UP);
        }
    }

    @Override
    public void onEntityItemDestroyed(ItemStack stack, Entity itemEntity, DamageSource damageSource) {
        SparkingProperty.ignite(itemEntity.level(), itemEntity.blockPosition(), Direction.DOWN);
    }

    public static void ignite(Level level, BlockPos pos, Direction direction) {
        if (!level.isClientSide() && (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos, (Direction)direction) || level.getBlockState(pos).canBeReplaced())) {
            level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            BlockState blockstate1 = BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos);
            level.setBlock(pos, blockstate1, 11);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return FastColor.ARGB32.lerp((float)sparkColor, (int)0x717171, (int)16761425);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    private static void onClientTick(ClientTickEvent.Pre event) {
        sparkColor = random.nextFloat() < 0.05f ? 1.0f : Math.max(0.0f, sparkColor - 0.033333335f);
    }
}

