/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.data.save.AlchemancyServerData;
import net.cibernet.alchemancy.properties.AbstractTimerProperty;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SporeCloudProperty
extends AbstractTimerProperty {
    private static final float RADIUS = 4.0f;
    private static final int COOLDOWN = 400;

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        Entity user;
        Entity entity = user = source == null ? target : source;
        if (this.getElapsedTime(stack) > 400L) {
            this.releaseSpores(user.level(), user, stack);
        }
    }

    @Override
    public void onDamageReceived(LivingEntity user, ItemStack weapon, EquipmentSlot slot, DamageSource damageSource) {
        if (this.getElapsedTime(weapon) > 400L) {
            this.releaseSpores(user.level(), (Entity)user, weapon);
        }
    }

    @Override
    public long getElapsedTime(ItemStack stack) {
        return ((Long)this.getData(stack)).equals(this.getDefaultData()) ? AlchemancyServerData.getGlobalTimer() : super.getElapsedTime(stack);
    }

    public void releaseSpores(Level level, Entity source, ItemStack stack) {
        this.resetStartTimestamp(stack);
        RandomSource rand = level.getRandom();
        List entities = level.getEntitiesOfClass(LivingEntity.class, source.getBoundingBox().inflate(4.0), EntitySelector.NO_SPECTATORS.and(target -> target.distanceTo(source) <= 4.0f));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = 0;
            while ((float)i < 160.0f) {
                serverLevel.sendParticles(SparklingProperty.getParticles(stack).orElse((ParticleOptions)ParticleTypes.FALLING_SPORE_BLOSSOM), source.position().x, source.position().y, source.position().z, 1, Math.sin(rand.nextDouble() * Math.PI * 2.0) * 4.0 * 0.5, Math.cos(rand.nextDouble() * Math.PI * 2.0) * 4.0 * 0.5, Math.cos(rand.nextDouble() * Math.PI * 2.0) * 4.0 * 0.5, 0.0);
                ++i;
            }
        }
        ItemStack refStack = stack.copy();
        for (LivingEntity target2 : entities) {
            if (target2 == source) continue;
            SporeCloudProperty.activateByEntity(source, (Entity)target2, stack);
        }
    }

    @Override
    public void onRootedAnimateTick(RootedItemBlockEntity root, RandomSource randomSource) {
        if (this.getElapsedTime(root.getItem()) > 400L) {
            SporeCloudProperty.playRootedParticles(root, randomSource, (ParticleOptions)ParticleTypes.FALLING_SPORE_BLOSSOM);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 8088947;
    }
}

