/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StonecuttingProperty
extends Property {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.stonecutter");

    @Override
    @Nullable
    public ItemInteractionResult onRootedRightClick(RootedItemBlockEntity root, Player user, InteractionHand hand, BlockHitResult hitResult) {
        StonecuttingProperty.openStonecuttingMenu(user, root.getItem());
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled()) {
            StonecuttingProperty.openStonecuttingMenu(event.getEntity(), event.getItemStack());
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        Player player = event.getPlayer();
        if (event.getLevel().isClientSide() || event.isCanceled() || player != null && player.isShiftKeyDown() || !InfusedPropertiesHelper.hasProperty(event.getItemStack(), AlchemancyProperties.INTERACTABLE)) {
            return;
        }
        Level level = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState blockState = level.getBlockState(blockPos);
        List recipes = level.getRecipeManager().getRecipesFor(RecipeType.STONECUTTING, (RecipeInput)new SingleRecipeInput(blockState.getBlock().asItem().getDefaultInstance()), level);
        Collections.shuffle(recipes);
        while (!recipes.isEmpty()) {
            BlockItem blockItem;
            BlockState resultState;
            ItemStack item = ((StonecutterRecipe)((RecipeHolder)recipes.getFirst()).value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            Item item2 = item.getItem();
            if (item2 instanceof BlockItem && (resultState = (blockItem = (BlockItem)item2).getBlock().getStateForPlacement(new BlockPlaceContext(event.getUseOnContext()))) != null) {
                level.destroyBlock(blockPos, false, null);
                level.setBlock(blockPos, resultState, 3);
                this.damageItem(event.getLevel(), (Entity)player, event.getItemStack(), LivingEntity.getSlotForHand((InteractionHand)event.getHand()), 1);
                Vec3 center = blockPos.getCenter();
                level.playSound(null, center.x, center.y, center.z, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
                event.setCancellationResult(ItemInteractionResult.SUCCESS);
                return;
            }
            recipes.removeFirst();
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(0.2f, 0xA8A8A8, 0xD8D8D8);
    }

    public static void openStonecuttingMenu(Player player, ItemStack sourceItem) {
        player.openMenu(StonecuttingProperty.getMenuProvider(sourceItem));
    }

    protected static MenuProvider getMenuProvider(final ItemStack sourceItem) {
        return new SimpleMenuProvider((containerId, playerInventory, player) -> new StonecutterMenu(containerId, playerInventory, new PlayerContainerLevelAccess(player)){

            public boolean stillValid(Player player) {
                return player.getInventory().getSelected().equals(sourceItem);
            }
        }, CONTAINER_TITLE);
    }

    public record PlayerContainerLevelAccess(Player player) implements ContainerLevelAccess
    {
        @NotNull
        public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> levelPosConsumer) {
            return Optional.ofNullable(levelPosConsumer.apply(this.player.level(), this.player.blockPosition()));
        }
    }
}

