/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.properties.Property;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

public class SwiftProperty
extends Property {
    private static final AttributeModifier SPEED_MOD = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"swift_property_modifier"), (double)0.55f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier ATTACK_SPEED_MOD = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"swift_property_modifier"), 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    @Override
    public void applyAttributes(ItemAttributeModifierEvent event) {
        if (SwiftProperty.getEquipmentSlotForItem(event.getItemStack()) == EquipmentSlot.LEGS) {
            event.addModifier(Attributes.MOVEMENT_SPEED, SPEED_MOD, EquipmentSlotGroup.LEGS);
        } else if (SwiftProperty.getEquipmentSlotForItem(event.getItemStack()) == EquipmentSlot.BODY) {
            event.addModifier(Attributes.MOVEMENT_SPEED, SPEED_MOD, EquipmentSlotGroup.BODY);
        }
        event.addModifier(Attributes.ATTACK_SPEED, ATTACK_SPEED_MOD, EquipmentSlotGroup.MAINHAND);
    }

    @Override
    public void onItemUseTick(LivingEntity user, ItemStack stack, LivingEntityUseItemEvent.Tick event) {
        if (event.getDuration() != stack.getUseDuration(user)) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return ((MobEffect)MobEffects.MOVEMENT_SPEED.value()).getColor();
    }
}

