/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.entity.InfusedItemProjectile;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ThrowableProperty
extends Property {
    public static final float THROW_VELOCITY = 1.5f;

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled()) {
            this.throwItem(event.getLevel(), (LivingEntity)event.getEntity(), event.getItemStack());
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        if (currentResult != InfusionPropertyDispenseBehavior.DispenseResult.PASS) {
            return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
        }
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.DISPENSING) && InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.HOLLOW)) {
            ItemStack storedItem = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(stack);
            if (storedItem.isEmpty()) {
                return InfusionPropertyDispenseBehavior.DispenseResult.PASS;
            }
            storedItem.shrink(1);
            ((HollowProperty)AlchemancyProperties.HOLLOW.get()).setData(stack, storedItem);
            stack = storedItem.copy();
        }
        stack = stack.copy();
        stack.setCount(1);
        this.throwItem(stack, blockSource, direction);
        return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
    }

    private void throwItem(ItemStack stack, BlockSource blockSource, Direction direction) {
        Position position = ProjectileItem.DispenseConfig.DEFAULT.positionFunction().getDispensePosition(blockSource, direction);
        this.throwItem((Level)blockSource.level(), stack, position.x(), position.y(), position.z(), direction.getStepX(), direction.getStepY(), direction.getStepZ(), ProjectileItem.DispenseConfig.DEFAULT.power() * (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SHARPSHOOTING) ? 1.5f : 1.0f), ProjectileItem.DispenseConfig.DEFAULT.uncertainty());
        InfusionPropertyDispenseBehavior.playDefaultEffects(blockSource, direction);
    }

    private void throwItem(Level level, ItemStack stack, double x, double y, double z, double xScale, double yScale, double zScale, float power, float inaccuracy) {
        Object projectile;
        Item item = stack.getItem();
        if (item instanceof ProjectileItem) {
            ProjectileItem projectileItem = (ProjectileItem)item;
            projectile = projectileItem.asProjectile(level, (Position)new Vec3(x, y, z), stack, Direction.UP);
        } else {
            InfusedItemProjectile itemProjectile = new InfusedItemProjectile(x, y, z, level);
            itemProjectile.setItem(stack.split(1));
            projectile = itemProjectile;
        }
        projectile.shoot(xScale, yScale, zScale, power, inaccuracy);
        level.addFreshEntity((Entity)projectile);
    }

    private void throwItem(Level level, LivingEntity user, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.DISPENSING) && InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.HOLLOW)) {
            ItemStack storedItem = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(stack);
            if (storedItem.isEmpty()) {
                user.playSound(SoundEvents.DISPENSER_FAIL);
                return;
            }
            storedItem.shrink(1);
            ((HollowProperty)AlchemancyProperties.HOLLOW.get()).setData(stack, storedItem);
            stack = storedItem.copy();
        }
        level.playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)AlchemancySoundEvents.THROWABLE.value(), SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            InfusedItemProjectile projectile;
            boolean sharpshooting = InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SHARPSHOOTING);
            Item item = stack.getItem();
            if (item instanceof ProjectileItem) {
                ProjectileItem projectileItem = (ProjectileItem)item;
                projectile = projectileItem.asProjectile(level, (Position)new Vec3(user.getX(), user.getEyeY() - (double)0.1f, user.getZ()), stack, Direction.UP);
            } else {
                InfusedItemProjectile itemProjectile = new InfusedItemProjectile(user, level);
                itemProjectile.setItem(stack.split(1));
                projectile = itemProjectile;
            }
            projectile.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f * (sharpshooting ? 1.5f : 1.0f), 1.0f);
            level.addFreshEntity((Entity)projectile);
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        }
        stack.consume(1, user);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 14667419;
    }
}

