/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.AbstractTimerProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TickingProperty
extends AbstractTimerProperty {
    private static final float TIMER_DURATION = 100.0f;

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        float percentageTimeLeft = this.getPercentageTimeLeft(stack);
        if (percentageTimeLeft > 0.0f && System.currentTimeMillis() % 1000L == 0L) {
            user.playSound((SoundEvent)AlchemancySoundEvents.TICKING.value(), 0.2f, 0.8f);
        }
        if (percentageTimeLeft == 0.0f) {
            InfusedPropertiesHelper.forEachProperty(stack, propertyHolder -> {
                if (!propertyHolder.equals(this.asHolder())) {
                    TickingProperty.activateByEntity(user, user, stack);
                }
            });
            if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.INTERACTABLE)) {
                this.resetStartTimestamp(stack);
            }
        }
    }

    public float getTimerDuration(ItemStack stack) {
        float result = 100.0f;
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SWIFT)) {
            result *= 0.5f;
        }
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SLUGGISH)) {
            result *= 2.0f;
        }
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.LAZY)) {
            result *= 2.0f;
        }
        return result;
    }

    @Override
    public void onItemPickedUp(Player player, ItemStack stack, ItemEntity itemEntity) {
        this.resetStartTimestamp(stack);
    }

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        this.resetStartTimestamp(stack);
    }

    public float getPercentageTimeLeft(ItemStack stack) {
        if ((Long)this.getData(stack) == 0L) {
            return -1.0f;
        }
        return 1.0f - Math.max(0.0f, (float)this.getElapsedTime(stack) / this.getTimerDuration(stack));
    }

    @Override
    public int getColor(ItemStack stack) {
        if ((Long)this.getData(stack) == 0L) {
            return this.getTickingColor(1.0f);
        }
        float timeLeft = this.getPercentageTimeLeft(stack);
        if (timeLeft <= 0.0f) {
            return 4261120;
        }
        return this.getTickingColor(1.0f);
    }

    private int getTickingColor(float speed) {
        return System.currentTimeMillis() / (long)((int)(speed * 1000.0f)) % 2L == 0L ? 0xFF0000 : 16438858;
    }
}

