/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesComponent;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.mixin.accessors.AbstractCauldronAccessor;
import net.cibernet.alchemancy.properties.ITintModifier;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

public class TintedProperty
extends Property
implements IDataHolder<Integer[]>,
ITintModifier {
    public static final int DEFAULT_COLOR = FastColor.ARGB32.opaque((int)0xFFFFFF);
    public static final Integer[] DEFAULT_COLORS = new Integer[0];
    private static final Int2ObjectOpenHashMap<DyeColor> TINT_TO_DYE_MAP = new Int2ObjectOpenHashMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(DyeColor::getTextureDiffuseColor, dye -> dye)));
    private static final int[] DYE_COLORS = Arrays.stream(DyeColor.values()).mapToInt(DyeColor::getTextureDiffuseColor).toArray();

    private static Component getColorName(int color) {
        DyeColor dyecolor = (DyeColor)TINT_TO_DYE_MAP.get(color);
        return dyecolor == null ? Component.translatable((String)"property.detail.color", (Object[])new Object[]{ColorUtils.colorToHexString(color)}).withColor(color) : Component.translatable((String)("color.minecraft." + dyecolor.getName())).withColor(color);
    }

    @Override
    public boolean cluelessCanReset() {
        return false;
    }

    @Override
    public boolean onInfusedByDormantProperty(ItemStack stack, ItemStack propertySource, ForgeRecipeGrid grid, List<Holder<Property>> propertiesToAdd, boolean consumeItem) {
        if (stack.is(AlchemancyTags.Items.CANNOT_TINT) || propertySource.is(AlchemancyTags.Items.APPLIES_CHROMA_TINT)) {
            return false;
        }
        Integer[] base = (Integer[])this.getData(stack);
        Integer[] colors = this.getDyeColor(propertySource);
        if (colors.length == 0) {
            return false;
        }
        if (consumeItem) {
            this.setData(stack, TintedProperty.mixColors(base, colors));
        }
        return true;
    }

    public Integer[] getDyeColor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            return new Integer[]{FastColor.ARGB32.color((int)255, (int)dyeItem.getDyeColor().getTextureDiffuseColor())};
        }
        if (((Integer[])this.getData(stack)).length > 0) {
            return (Integer[])this.getData(stack);
        }
        return DEFAULT_COLORS;
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        AbstractCauldronBlock cauldron;
        if (!InfusedPropertiesHelper.hasInfusedProperty(event.getItemStack(), this.asHolder())) {
            return;
        }
        BlockState state = event.getLevel().getBlockState(event.getPos());
        Block block = state.getBlock();
        if (block instanceof AbstractCauldronBlock && ((AbstractCauldronAccessor)(cauldron = (AbstractCauldronBlock)block)).getInteractions().equals((Object)CauldronInteraction.WATER)) {
            if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)LayeredCauldronBlock.LEVEL)) {
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)event.getLevel(), (BlockPos)event.getPos());
            }
            this.setData(event.getItemStack(), this.getDefaultData());
            InfusedPropertiesHelper.removeProperty(event.getItemStack(), this.asHolder());
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public int getTint(ItemStack stack, int tintIndex, int originalTint, int currentTint) {
        boolean tintBase = stack.is(AlchemancyTags.Items.TINT_BASE_LAYER);
        boolean dontTintBase = stack.is(AlchemancyTags.Items.DONT_TINT_BASE_LAYER);
        return tintBase && dontTintBase || tintBase && tintIndex > 0 || dontTintBase && tintIndex == 0 ? currentTint : FastColor.ARGB32.color((int)FastColor.ARGB32.alpha((int)currentTint), (int)this.getColor(stack));
    }

    @Override
    public Integer[] readData(CompoundTag tag) {
        Integer[] integerArray;
        if (tag.contains("colors", 11)) {
            integerArray = this.toIntegerArray(tag.getIntArray("colors"));
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = tag.getInt("color");
        }
        return integerArray;
    }

    @Override
    public CompoundTag writeData(final Integer[] data) {
        return new CompoundTag(this){
            {
                this.putIntArray("colors", Arrays.stream(data).mapToInt(Integer::valueOf).toArray());
            }
        };
    }

    @Override
    public Integer[] combineData(Integer @Nullable [] currentData, Integer[] newData) {
        return TintedProperty.mixColors(currentData, newData);
    }

    @Override
    public void setData(ItemStack stack, int value) {
        IDataHolder.super.setData(stack, new Integer[]{value});
    }

    @Override
    public Integer[] getDefaultData() {
        return DEFAULT_COLORS;
    }

    @Override
    public int getColor(ItemStack stack) {
        Integer[] colors = (Integer[])this.getData(stack);
        if (colors.length == 0 && InfusedPropertiesHelper.hasDormantProperty(stack, this.asHolder())) {
            return -1;
        }
        return colors.length == 0 ? ColorUtils.interpolateColorsAndWait(1.0f, 1.0f, DYE_COLORS) : ColorUtils.interpolateColorsOverTime(1.0f, Arrays.stream(colors).mapToInt(Integer::valueOf).toArray());
    }

    private Integer[] toIntegerArray(int ... numbers) {
        return (Integer[])Arrays.stream(numbers).boxed().toArray(Integer[]::new);
    }

    @Override
    public Component getName(ItemStack stack) {
        int[] colors = Arrays.stream(this.getDyeColor(stack)).mapToInt(Integer::valueOf).toArray();
        return colors.length == 0 ? super.getName(stack) : super.getName(stack).copy().withColor(ColorUtils.interpolateColorsOverTime(1.0f, colors));
    }

    @Override
    public Collection<ItemStack> populateCreativeTab(DeferredItem<Item> capsuleItem, Holder<Property> holder) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (DyeColor dye : DyeColor.values()) {
            ItemStack stack = capsuleItem.toStack();
            stack.set(AlchemancyItems.Components.STORED_PROPERTIES, (Object)new InfusedPropertiesComponent(List.of(holder)));
            this.setData(stack, dye.getTextureDiffuseColor());
            result.add(stack);
        }
        return result;
    }

    public static Integer[] mixColors(Integer[] base, Integer[] colors) {
        if (colors.length == 0) {
            return base;
        }
        if (base.length == 0) {
            return colors;
        }
        for (int i = 0; i < base.length; ++i) {
            base[i] = base[i] == DEFAULT_COLOR ? FastColor.ARGB32.color((int)255, (int)colors[Math.min(i, colors.length - 1)]) : TintedProperty.mixColors(base[i], List.of(colors[Math.min(i, colors.length - 1)]));
        }
        return base;
    }

    public static int mixColors(int base, List<Integer> dyes) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        int i1 = 0;
        int j1 = FastColor.ARGB32.red((int)base);
        int k1 = FastColor.ARGB32.green((int)base);
        int l1 = FastColor.ARGB32.blue((int)base);
        l += Math.max(j1, Math.max(k1, l1));
        i += j1;
        j += k1;
        k += l1;
        ++i1;
        for (int dyeitem : dyes) {
            int i2 = FastColor.ARGB32.red((int)dyeitem);
            int j2 = FastColor.ARGB32.green((int)dyeitem);
            int k2 = FastColor.ARGB32.blue((int)dyeitem);
            l += Math.max(i2, Math.max(j2, k2));
            i += i2;
            j += j2;
            k += k2;
            ++i1;
        }
        int l2 = i / i1;
        int i3 = j / i1;
        int k3 = k / i1;
        float f = (float)l / (float)i1;
        float f1 = Math.max(l2, Math.max(i3, k3));
        l2 = (int)((float)l2 * f / f1);
        i3 = (int)((float)i3 * f / f1);
        k3 = (int)((float)k3 * f / f1);
        return FastColor.ARGB32.color((int)0, (int)l2, (int)i3, (int)k3);
    }
}

