/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class UndyingProperty
extends Property
implements IDataHolder<Integer> {
    final int[] colors = new int[]{4318847, 16645102, 15391620, 16645102};
    private static final int MAX = 5;

    @Override
    public int modifyDurabilityConsumed(ItemStack stack, ServerLevel level, @Nullable LivingEntity user, int originalAmount, int resultingAmount, RandomSource random) {
        if (stack.getMaxDamage() <= stack.getDamageValue() + resultingAmount) {
            UndyingProperty.repairItem(stack, (int)((float)stack.getMaxDamage() * 0.4f));
            int uses = (Integer)this.getData(stack);
            if (uses <= 1) {
                InfusedPropertiesHelper.removeProperty(stack, AlchemancyProperties.UNDYING);
            } else {
                this.setData(stack, Integer.valueOf(uses - 1));
            }
            if (user != null) {
                level.playSound(null, user.getX(), user.getY(), user.getZ(), AlchemancySoundEvents.UNDYING, SoundSource.PLAYERS, 1.0f, 1.0f);
                level.sendParticles(SparklingProperty.getParticles(stack).orElse((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING), user.getX(), user.getY(0.5), user.getZ(), 10, (double)0.15f, 0.0, (double)0.15f, 0.2);
            }
            if (user != null) {
                Player player;
                level.playSound(user instanceof Player ? (player = (Player)user) : null, user.position().x, user.position().y, user.position().z, SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 0.65f, 1.0f);
            }
            return 0;
        }
        return resultingAmount;
    }

    @Override
    public boolean onInfusedByDormantProperty(ItemStack stack, ItemStack propertySource, ForgeRecipeGrid grid, List<Holder<Property>> propertiesToAdd, boolean consumeItem) {
        int amount = Math.max(1, (Integer)this.getData(stack));
        if (amount >= 5) {
            return false;
        }
        if (consumeItem) {
            this.setData(stack, Integer.valueOf(Math.min(5, (InfusedPropertiesHelper.hasProperty(stack, this.asHolder()) ? amount : 0) + UndyingProperty.getSourceAmount(propertySource))));
        }
        return true;
    }

    private static int getSourceAmount(ItemStack stack) {
        return stack.is(AlchemancyTags.Items.VALUABLE_UNDYING_SOURCE) ? 3 : 1;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        int amount = (Integer)this.getData(stack);
        return amount <= 1 ? super.getDisplayText(stack) : Component.translatable((String)"property.detail.item_count", (Object[])new Object[]{super.getDisplayText(stack), amount}).withColor(this.getColor(stack));
    }

    @Override
    public Component getName(ItemStack stack) {
        int amount = UndyingProperty.getSourceAmount(stack);
        return amount <= 1 ? super.getName(stack) : Component.translatable((String)"property.detail.item_count", (Object[])new Object[]{super.getName(stack), amount}).withColor(this.getColor(stack));
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(0.5f, this.colors);
    }

    @Override
    public Integer readData(CompoundTag tag) {
        return tag.contains("uses") ? tag.getInt("uses") : this.getDefaultData().intValue();
    }

    @Override
    public CompoundTag writeData(final Integer data) {
        return new CompoundTag(this){
            {
                this.putInt("uses", data);
            }
        };
    }

    @Override
    public Integer getDefaultData() {
        return 1;
    }
}

