/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.ClientUtil;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.WayfindingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber
public class WayfindingProperty
extends Property
implements IDataHolder<Tuple<WayfindData, RotationData>> {
    private static final Tuple<WayfindData, RotationData> DEFAULT = new Tuple((Object)WayfindData.DEFAULT, (Object)RotationData.DEFAULT);

    @Override
    public boolean onInfusedByDormantProperty(ItemStack stack, ItemStack propertySource, ForgeRecipeGrid grid, List<Holder<Property>> propertiesToAdd, boolean consumeItem) {
        if (super.onInfusedByDormantProperty(stack, propertySource, grid, propertiesToAdd, consumeItem)) {
            LodestoneTracker tracker;
            if (consumeItem && propertySource.has(DataComponents.LODESTONE_TRACKER) && (tracker = (LodestoneTracker)propertySource.get(DataComponents.LODESTONE_TRACKER)).target().isPresent()) {
                this.setData(stack, ((WayfindData)this.getDefaultData().getA()).withBlockPosition((GlobalPos)tracker.target().get()));
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        block3: {
            if (level.isClientSide()) {
                return;
            }
            data = (WayfindData)((Tuple)this.getData(stack)).getA();
            if (!data.fallbackPos.isEmpty() && data.fallbackPos.get().dimension().location().equals((Object)level.dimension().location())) break block3;
            if (!data.targetedPos.isEmpty() && !data.targetedPos.get().dimension().location().equals((Object)user.level().dimension().location()) || !(user instanceof ServerPlayer)) ** GOTO lbl12
            player = (ServerPlayer)user;
            if (!level.dimension().location().equals((Object)player.getRespawnDimension().location())) ** GOTO lbl12
            if (player.getRespawnPosition() != null) {
                fallback = new GlobalPos(level.dimension(), player.getRespawnPosition());
            } else {
                return;
lbl12:
                // 2 sources

                fallback = level.dimensionTypeRegistration().is(AlchemancyTags.Dimensions.WAYFINDING_POINTS_TO_ORIGIN) != false ? new GlobalPos(level.dimension(), BlockPos.ZERO) : new GlobalPos(level.dimension(), user.blockPosition());
            }
            this.setData(stack, data.withFallback(fallback));
        }
    }

    @Override
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity;
        WayfindData data = (WayfindData)((Tuple)this.getData(event.getItemStack())).getA();
        if (!data.hasTarget() && (entity = event.getTarget()) instanceof Player) {
            Player target = (Player)entity;
            this.setData(event.getItemStack(), data.withPlayer(target));
            WayfindingProperty.playWayfindingSound((Entity)target);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        if (!event.getLevel().getBlockState(event.getPos()).is(AlchemancyTags.Blocks.WAYFINDING_TARGETABLE)) {
            return;
        }
        WayfindData data = (WayfindData)((Tuple)this.getData(event.getItemStack())).getA();
        if (!data.hasTarget()) {
            this.setData(event.getItemStack(), data.withBlockPosition(new GlobalPos(event.getLevel().dimension(), event.getPos())));
            WayfindingProperty.playWayfindingSound(event.getLevel(), event.getPos());
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static void playWayfindingSound(Entity source) {
        WayfindingProperty.playWayfindingSound(source.level(), source.position());
    }

    public static void playWayfindingSound(Level level, BlockPos pos) {
        WayfindingProperty.playWayfindingSound(level, pos.getCenter());
    }

    public static void playWayfindingSound(Level level, Vec3 pos) {
        level.playSound(null, pos.x, pos.y, pos.z, (SoundEvent)AlchemancySoundEvents.WAYFINDING.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        Inventory inventory = event.getEntity().getInventory();
        if (event.getNewSpawn() != null) {
            for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
                WayfindData data;
                ItemStack stack = inventory.getItem(slot);
                int currentSlot = slot;
                if (!InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.WAYFINDING) || !(data = (WayfindData)((Tuple)((WayfindingProperty)AlchemancyProperties.WAYFINDING.get()).getData(stack)).getA()).fallbackPos().isPresent() || !data.fallbackPos().get().dimension().equals(event.getSpawnLevel())) continue;
                ((WayfindingProperty)AlchemancyProperties.WAYFINDING.get()).setData(stack, data.withFallback(new GlobalPos(event.getSpawnLevel(), event.getNewSpawn())));
            }
        }
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        WayfindData data = (WayfindData)((Tuple)this.getData(stack)).getA();
        if (!data.hasTarget()) {
            return super.getDisplayText(stack);
        }
        MutableComponent target = Component.empty();
        if (data.targetedPlayer.isPresent()) {
            Optional<Player> targetPlayer = CommonUtils.getPlayerByUUID((UUID)data.targetedPlayer.get().getA());
            target = Component.literal((String)(targetPlayer.isPresent() ? targetPlayer.get().getGameProfile().getName() : (String)data.targetedPlayer.get().getB()));
        } else if (data.targetedPos.isPresent()) {
            GlobalPos pos = data.targetedPos.get();
            target = (ServerLifecycleHooks.getCurrentServer() == null || !(ServerLifecycleHooks.getCurrentServer() instanceof DedicatedServer)) && !ClientUtil.getCurrentLevel().dimension().equals(pos.dimension()) ? Component.literal((String)pos.dimension().location().toString()) : Component.translatable((String)"property.detail.block_position", (Object[])new Object[]{pos.pos().getX(), pos.pos().getY(), pos.pos().getZ()});
        }
        return Component.translatable((String)"property.detail", (Object[])new Object[]{super.getDisplayText(stack), target}).withColor(this.getColor(stack));
    }

    @Override
    public void setData(ItemStack item, WayfindData value) {
        IDataHolder.super.setData(item, new Tuple((Object)value, (Object)(ServerLifecycleHooks.getCurrentServer() == null || !(ServerLifecycleHooks.getCurrentServer() instanceof DedicatedServer) ? (RotationData)((Tuple)this.getData(item)).getB() : RotationData.DEFAULT)));
    }

    @Override
    public void setData(ItemStack item, RotationData value) {
        IDataHolder.super.setData(item, new Tuple((Object)((WayfindData)((Tuple)this.getData(item)).getA()), (Object)value));
    }

    @Override
    public int getColor(ItemStack stack) {
        return 3701941;
    }

    @Override
    public Tuple<WayfindData, RotationData> readData(CompoundTag tag) {
        return new Tuple((Object)WayfindData.fromNbt(tag), (Object)RotationData.fromNbt(tag.getCompound("rotation_data")));
    }

    @Override
    public CompoundTag writeData(Tuple<WayfindData, RotationData> data) {
        CompoundTag tag = ((WayfindData)data.getA()).toNbt();
        tag.put("rotation_data", (Tag)((RotationData)data.getB()).toNbt());
        return tag;
    }

    @Override
    public Tuple<WayfindData, RotationData> getDefaultData() {
        return DEFAULT;
    }

    public record WayfindData(Optional<Tuple<UUID, String>> targetedPlayer, Optional<GlobalPos> targetedPos, Optional<GlobalPos> fallbackPos) {
        public static final WayfindData DEFAULT = new WayfindData(Optional.empty(), Optional.empty(), Optional.empty());

        public static WayfindData fromNbt(CompoundTag tag) {
            CompoundTag targetTag;
            Optional<GlobalPos> targetedPos = Optional.empty();
            Optional<GlobalPos> fallbackPos = Optional.empty();
            if (tag.contains("target_position", 10)) {
                targetTag = tag.getCompound("target_position");
                targetedPos = Optional.of(new GlobalPos(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)targetTag.getString("dimension"))), NbtUtils.readBlockPos((CompoundTag)targetTag, (String)"pos").orElse(BlockPos.ZERO)));
            }
            if (tag.contains("fallback_position", 10)) {
                targetTag = tag.getCompound("fallback_position");
                fallbackPos = Optional.of(new GlobalPos(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)targetTag.getString("dimension"))), NbtUtils.readBlockPos((CompoundTag)targetTag, (String)"pos").orElse(BlockPos.ZERO)));
            }
            return new WayfindData(Optional.ofNullable(tag.hasUUID("target_player") ? new Tuple((Object)tag.getUUID("target_player"), (Object)(tag.contains("target_player_name", 8) ? tag.getString("target_player_name") : "???")) : null), targetedPos, fallbackPos);
        }

        public WayfindData withPlayer(Player targetedPlayer) {
            return new WayfindData(Optional.of(new Tuple((Object)targetedPlayer.getUUID(), (Object)targetedPlayer.getGameProfile().getName())), Optional.empty(), this.fallbackPos);
        }

        public WayfindData withBlockPosition(GlobalPos targetedPos) {
            return new WayfindData(Optional.empty(), Optional.of(targetedPos), this.fallbackPos);
        }

        public WayfindData withFallback(GlobalPos fallbackPos) {
            return new WayfindData(this.targetedPlayer, this.targetedPos, Optional.ofNullable(fallbackPos));
        }

        public float getRotation(Entity user) {
            float result;
            Player player;
            Level level = user.level();
            Optional<BlockPos> target = this.getTargetPos(level);
            if (this.targetedPlayer.isPresent() && (target.isEmpty() || user instanceof Player && (player = (Player)user).getUUID().equals(this.targetedPlayer.get().getA()))) {
                result = WayfindingUtil.getRandomlySpinningRotation(0, level.getGameTime());
            } else if (target.isPresent()) {
                result = WayfindingUtil.getRotationTowardsCompassTarget(user, level.getGameTime(), target.get());
            } else if (this.fallbackPos.isPresent() && this.fallbackPos.get().dimension().location().equals((Object)user.level().dimension().location())) {
                result = WayfindingUtil.getRotationTowardsCompassTarget(user, level.getGameTime(), this.fallbackPos.get().pos());
            } else {
                GlobalPos worldSpawn = CompassItem.getSpawnPosition((Level)level);
                return worldSpawn != null ? WayfindingUtil.getRotationTowardsCompassTarget(user, level.getGameTime(), worldSpawn.pos()) : WayfindingUtil.getRandomlySpinningRotation(0, level.getGameTime());
            }
            return result;
        }

        public Optional<BlockPos> getTargetPos(Level level) {
            Player target;
            if (this.targetedPlayer.isPresent() && (target = level.getPlayerByUUID((UUID)this.targetedPlayer.get().getA())) != null) {
                return Optional.of(target.blockPosition());
            }
            if (this.targetedPos.isPresent() && this.targetedPos.get().dimension().location().equals((Object)level.dimension().location())) {
                return Optional.of(this.targetedPos.get().pos());
            }
            return Optional.empty();
        }

        public boolean hasTarget() {
            return this.targetedPos.isPresent() || this.targetedPlayer.isPresent();
        }

        public CompoundTag toNbt() {
            return new CompoundTag(){
                {
                    CompoundTag targetTag;
                    targetedPlayer.ifPresent(player -> {
                        this.putUUID("target_player", (UUID)player.getA());
                        this.putString("target_player_name", (String)player.getB());
                    });
                    if (targetedPos.isPresent()) {
                        targetTag = new CompoundTag();
                        targetTag.putString("dimension", targetedPos.get().dimension().location().toString());
                        targetTag.put("pos", NbtUtils.writeBlockPos((BlockPos)targetedPos.get().pos()));
                        this.put("target_position", (Tag)targetTag);
                    }
                    if (fallbackPos.isPresent()) {
                        targetTag = new CompoundTag();
                        targetTag.putString("dimension", fallbackPos.get().dimension().location().toString());
                        targetTag.put("pos", NbtUtils.writeBlockPos((BlockPos)fallbackPos.get().pos()));
                        this.put("fallback_position", (Tag)targetTag);
                    }
                }
            };
        }

        public Optional<ResourceKey<Level>> getTargetDimension(Level level) {
            Player target;
            if (this.targetedPlayer.isPresent() && (target = level.getPlayerByUUID((UUID)this.targetedPlayer.get().getA())) != null) {
                return Optional.of(target.level().dimension());
            }
            if (this.targetedPos.isPresent()) {
                return Optional.of(this.targetedPos.get().dimension());
            }
            return Optional.empty();
        }
    }

    public record RotationData(float rotation, float previousRotaion, long lastUpdateTick) {
        public static final RotationData DEFAULT = new RotationData(0.0f, 0.0f, 0L);

        public RotationData step(float rotation, long currentTick) {
            return new RotationData(rotation, this.rotation, currentTick);
        }

        public static RotationData fromNbt(CompoundTag tag) {
            return new RotationData(tag.getFloat("rotation"), tag.getFloat("previous_rotation"), tag.getLong("last_update_tick"));
        }

        public CompoundTag toNbt() {
            return new CompoundTag(){
                {
                    this.putFloat("rotation", rotation);
                    this.putFloat("previous_rotation", previousRotaion);
                    this.putLong("last_update_tick", lastUpdateTick);
                }
            };
        }

        public boolean shouldUpdate(long gameTime) {
            return this.lastUpdateTick != gameTime;
        }
    }
}

