/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.data;

import java.util.Optional;
import net.cibernet.alchemancy.item.components.PropertyDataComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IDataHolder<T> {
    public T readData(CompoundTag var1);

    public CompoundTag writeData(T var1);

    public T getDefaultData();

    default public T combineData(@Nullable T currentData, T newData) {
        return currentData == null ? newData : currentData;
    }

    default public void combineDataAndSet(ItemStack stack, ItemStack from) {
        this.setData(stack, this.hasData(stack) ? this.combineData(this.getData(stack), this.getData(from)) : this.getData(from));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean hasData(ItemStack stack) {
        if (!stack.has(AlchemancyItems.Components.PROPERTY_DATA)) return false;
        IDataHolder iDataHolder = this;
        if (!(iDataHolder instanceof Property)) return false;
        Property property = (Property)((Object)iDataHolder);
        if (!((PropertyDataComponent)stack.get(AlchemancyItems.Components.PROPERTY_DATA)).getDataNbt(property.asHolder()).isPresent()) return false;
        return true;
    }

    default public T getData(ItemStack stack) {
        IDataHolder iDataHolder = this;
        if (iDataHolder instanceof Property) {
            Optional<CompoundTag> nbt;
            Property property = (Property)((Object)iDataHolder);
            if (stack.has(AlchemancyItems.Components.PROPERTY_DATA) && (nbt = ((PropertyDataComponent)stack.get(AlchemancyItems.Components.PROPERTY_DATA)).getDataNbt(AlchemancyProperties.getHolder(property))).isPresent()) {
                return this.readData(nbt.get());
            }
            return this.getDefaultData();
        }
        return this.getDefaultData();
    }

    default public void setData(ItemStack stack, T value) {
        stack.set(AlchemancyItems.Components.PROPERTY_DATA, (Object)this.setData((PropertyDataComponent)stack.getOrDefault(AlchemancyItems.Components.PROPERTY_DATA, (Object)PropertyDataComponent.EMPTY), value));
    }

    default public void removeData(ItemStack stack) {
        PropertyDataComponent comp = (PropertyDataComponent)stack.getOrDefault(AlchemancyItems.Components.PROPERTY_DATA, (Object)PropertyDataComponent.EMPTY);
        comp = this.removeData(comp);
        stack.set(AlchemancyItems.Components.PROPERTY_DATA, (Object)comp);
    }

    default public PropertyDataComponent setData(PropertyDataComponent component, T value) {
        IDataHolder iDataHolder = this;
        if (iDataHolder instanceof Property) {
            Property property = (Property)((Object)iDataHolder);
            PropertyDataComponent.Mutable data = new PropertyDataComponent.Mutable(component);
            data.setDataNbt(AlchemancyProperties.getHolder(property), this.writeData(value));
            return data.toImmutable();
        }
        return component;
    }

    default public PropertyDataComponent removeData(PropertyDataComponent component) {
        IDataHolder iDataHolder = this;
        if (iDataHolder instanceof Property) {
            Property property = (Property)((Object)iDataHolder);
            PropertyDataComponent.Mutable data = new PropertyDataComponent.Mutable(component);
            data.removeData(AlchemancyProperties.getHolder(property));
            return data.toImmutable();
        }
        return component;
    }

    default public boolean cluelessCanReset() {
        return true;
    }

    default public void copyData(ItemStack from, ItemStack to) {
        this.setData(to, this.getData(from));
    }
}

