/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.entangled;

import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.properties.special.AirWalkingProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntangledProperty
extends Property
implements IDataHolder<EntangledData> {
    @Override
    public int getColor(ItemStack stack) {
        return 15269632;
    }

    @Override
    public void onStackedOverMe(ItemStack carriedItem, ItemStack stack, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (isCancelled.get()) {
            return;
        }
        EntangledData data = (EntangledData)this.getData(stack);
        if (clickAction != ClickAction.SECONDARY || carriedItem.isEmpty() || !data.equals(this.getDefaultData()) || InfusedPropertiesHelper.getRemainingInfusionSlots(carriedItem) <= 0) {
            return;
        }
        ItemStack entangleTarget = carriedItem.split(1);
        InfusedPropertiesHelper.addProperty(entangleTarget, this.asHolder());
        this.setStoredItem(stack, entangleTarget);
        isCancelled.set(true);
    }

    public boolean getToggle(ItemStack stack) {
        return ((EntangledData)this.getData(stack)).toggled();
    }

    public ItemStack getStoredItem(ItemStack stack) {
        return ((EntangledData)this.getData((ItemStack)stack)).stack;
    }

    public void setToggle(ItemStack stack, boolean value) {
        this.setData(stack, new EntangledData(((EntangledData)this.getData((ItemStack)stack)).stack, value));
    }

    public void setData(ItemStack stack, ItemStack storedStack, boolean toggled) {
        this.setData(stack, new EntangledData(storedStack, toggled));
    }

    public void setStoredItem(ItemStack stack, ItemStack value) {
        this.setData(stack, new EntangledData(value, ((EntangledData)this.getData((ItemStack)stack)).toggled));
    }

    public ItemStack shift(ItemStack stack, @Nullable Entity user) {
        EntangledData data = (EntangledData)this.getData(stack);
        ItemStack storedItem = data.stack;
        if (storedItem.equals(this.getDefaultData().stack)) {
            return stack;
        }
        this.setStoredItem(stack, this.getDefaultData().stack);
        this.setData(storedItem, stack, data.toggled);
        if (user != null && InfusedPropertiesHelper.hasProperty(storedItem, AlchemancyProperties.AIR_WALKER)) {
            ((AirWalkingProperty)AlchemancyProperties.AIR_WALKER.value()).setData(storedItem, Double.valueOf(user.getY()));
        }
        return storedItem;
    }

    public void afterShiftingProjectile(ItemStack oldStack, ItemStack newStack, Entity projectile) {
        if (!InfusedPropertiesHelper.hasProperty(newStack, AlchemancyProperties.PHASING)) {
            projectile.noPhysics = false;
        }
        if (!InfusedPropertiesHelper.hasProperty(newStack, AlchemancyProperties.GLOWING_AURA)) {
            projectile.setGlowingTag(false);
        }
        if (!InfusedPropertiesHelper.hasProperty(newStack, AlchemancyProperties.ANTIGRAV)) {
            projectile.setNoGravity(false);
        }
    }

    @Override
    public <T> Object modifyDataComponent(ItemStack stack, DataComponentType<? extends T> dataType, T data) {
        return dataType == DataComponents.MAX_STACK_SIZE ? Integer.valueOf(1) : data;
    }

    @Override
    public EntangledData readData(CompoundTag tag) {
        return !tag.contains("item") ? this.getDefaultData() : new EntangledData(ItemStack.parse((HolderLookup.Provider)CommonUtils.registryAccessStatic(), (Tag)tag.getCompound("item")).orElse(this.getDefaultData().stack()), tag.getBoolean("toggled"));
    }

    @Override
    public CompoundTag writeData(final EntangledData data) {
        return new CompoundTag(this){
            {
                if (!data.stack.isEmpty()) {
                    this.put("item", data.stack.save((HolderLookup.Provider)CommonUtils.registryAccessStatic()));
                }
                this.putBoolean("toggled", data.toggled);
            }
        };
    }

    @Override
    public EntangledData getDefaultData() {
        return EntangledData.DEFAULT;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        Component name = super.getDisplayText(stack);
        ItemStack storedStack = ((EntangledData)this.getData((ItemStack)stack)).stack;
        if (!storedStack.isEmpty()) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, Component.translatable((String)"property.detail.item_count", (Object[])new Object[]{storedStack.getHoverName(), storedStack.getCount()})}).withColor(this.getColor(stack));
        }
        return name;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public record EntangledData(ItemStack stack, boolean toggled) {
        public static final EntangledData DEFAULT = new EntangledData(ItemStack.EMPTY, false);

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EntangledData)) {
                return false;
            }
            EntangledData data = (EntangledData)obj;
            return this.stack.equals(data.stack);
        }
    }
}

