/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.entangled;

import net.cibernet.alchemancy.entity.InfusedItemProjectile;
import net.cibernet.alchemancy.mixin.accessors.LivingEntityAccessor;
import net.cibernet.alchemancy.properties.entangled.AbstractEntangledProperty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class JumpEntangledProperty
extends AbstractEntangledProperty {
    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        boolean jumping = ((LivingEntityAccessor)user).isJumping();
        if (jumping != this.getToggle(stack) && player.getInventory().getItem(inventorySlot) == stack) {
            this.setToggle(stack, jumping);
            ItemStack shiftStack = this.shift(stack, (Entity)player);
            player.getInventory().setItem(inventorySlot, shiftStack);
            if (jumping && inventorySlot == 38 && !player.onGround() && stack != shiftStack && shiftStack.canElytraFly((LivingEntity)player)) {
                player.startFallFlying();
            }
        }
    }

    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity itemEntity) {
        LivingEntity living;
        boolean jumping;
        Entity user = itemEntity.getOwner();
        if (itemEntity.getItem() == stack && user instanceof LivingEntity && (jumping = ((LivingEntityAccessor)(living = (LivingEntity)user)).isJumping()) != this.getToggle(stack)) {
            this.setToggle(stack, jumping);
            itemEntity.setItem(this.shift(stack, (Entity)living));
            this.afterShiftingProjectile(stack, itemEntity.getItem(), (Entity)itemEntity);
        }
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        LivingEntity living;
        boolean jumping;
        Entity user;
        InfusedItemProjectile infusedItemProjectile;
        if (projectile instanceof InfusedItemProjectile && (infusedItemProjectile = (InfusedItemProjectile)projectile).getItem() == stack && (user = projectile.getOwner()) instanceof LivingEntity && (jumping = ((LivingEntityAccessor)(living = (LivingEntity)user)).isJumping()) != this.getToggle(stack)) {
            this.setToggle(stack, jumping);
            infusedItemProjectile.setItem(this.shift(stack, (Entity)living));
            this.afterShiftingProjectile(stack, infusedItemProjectile.getItem(), (Entity)infusedItemProjectile);
        }
    }
}

