/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.entangled;

import net.cibernet.alchemancy.entity.InfusedItemProjectile;
import net.cibernet.alchemancy.properties.entangled.AbstractEntangledProperty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SprintEntangledProperty
extends AbstractEntangledProperty {
    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (user.isSprinting() != this.getToggle(stack) && player.getInventory().getItem(inventorySlot) == stack) {
                this.setToggle(stack, user.isSprinting());
                player.getInventory().setItem(inventorySlot, this.shift(stack, (Entity)player));
            }
        }
    }

    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity itemEntity) {
        Entity user = itemEntity.getOwner();
        if (itemEntity.getItem() == stack && user != null && user.isSprinting() != this.getToggle(stack)) {
            this.setToggle(stack, user.isSprinting());
            itemEntity.setItem(this.shift(stack, user));
            this.afterShiftingProjectile(stack, itemEntity.getItem(), (Entity)itemEntity);
        }
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        Entity user;
        InfusedItemProjectile infusedItemProjectile;
        if (projectile instanceof InfusedItemProjectile && (infusedItemProjectile = (InfusedItemProjectile)projectile).getItem() == stack && (user = projectile.getOwner()) != null && user.isSprinting() != this.getToggle(stack)) {
            this.setToggle(stack, user.isSprinting());
            infusedItemProjectile.setItem(this.shift(stack, user));
            this.afterShiftingProjectile(stack, infusedItemProjectile.getItem(), (Entity)infusedItemProjectile);
        }
    }
}

